//definiujemy poczenia LCD
sbit LCD_RS at RB1_bit;
sbit LCD_EN at RB0_bit;
sbit LCD_D4 at RB5_bit;
sbit LCD_D5 at RB4_bit;
sbit LCD_D6 at RB3_bit;
sbit LCD_D7 at RB2_bit;

sbit LCD_RS_Direction at TRISB1_bit;
sbit LCD_EN_Direction at TRISB0_bit;
sbit LCD_D4_Direction at TRISB5_bit;
sbit LCD_D5_Direction at TRISB4_bit;
sbit LCD_D6_Direction at TRISB3_bit;
sbit LCD_D7_Direction at TRISB2_bit;

//dane do zapisania w pamici i wywietlenia na wywietlaczu LCD
char napis1[11] = "Takie dane";
char napis2[14] = "tekstem zwane";
char bufor[15];

void main()
{
 unsigned char k;
 /////////////////////////////////////////////////////
 ADCON1 = 0x06;         //wyczenie linii analogowych
 /////////////////////////////////////////////////////
 Lcd_Init();            //inicjalizacja wywietlacza LCD
 /////////////////////////////////////////////////////
 I2C1_Init(100000);     //inicjalizacja interfejsu I2C
 /////////////////////////////////////////////////////
 //zapisujemy dane do pamici EEPROM
 //zapisujemy napis1
 for(k=0; k<11; k++)
 {
  I2C1_Start();       //wysyamy sygna START
  I2C1_Wr(0xA2);      //wysyamy pierwszy bajt (adres urzdzenia 0xA, najst. bity adresu 1)
  I2C1_Wr(k);         //wysyamy drugi bajt (adres w pamici EEPROM)
  I2C1_Wr(napis1[k]); //dane do zapisania w komrce pamici
  I2C1_Stop();        //wysyamy sygna STOP

  Delay_ms(20);       //czekamy na zakoczenie procesu zapisywania
 }
 //zapisujemy napis2
 for(k=0; k<14; k++)
 {
  I2C1_Start();       //wysyamy sygna START
  I2C1_Wr(0xA4);      //wysyamy pierwszy bajt (adres urzdzenia 0xA, najst. bity adresu 2)
  I2C1_Wr(k);         //wysyamy drugi bajt (adres w pamici EEPROM)
  I2C1_Wr(napis2[k]); //dane do zapisania w komrce pamici
  I2C1_Stop();        //wysyamy sygna STOP

  Delay_ms(20);       //czekamy na zakoczenie procesu zapisywania
 }

 /////////////////////////////////////////////////////
 //odczytujemy dane z pamici EEPROM
 //odczytujemy pierwszy napis
 I2C1_Start();               //wysyamy sygna START
 I2C1_Wr(0xA2);              //wysyamy pierwszy bajt (adres urzdzenia 0xA0, najst. bity adresu 1)
 I2C1_Wr(0);                 //wysyamy drugi bajt (adres pocztkowy w pamici EEPROM)
 I2C1_Repeated_Start();      //powtarzamy sygna START
 I2C1_Wr(0xA3);              //wysyamy adres urzdzenia (0xA2) z ustawionym bitem W
 for(k=0; k<10; k++)
 {
  bufor[k] = I2C1_Rd(1);     //odczytujemy dane, potwierdzamy ACK
  Delay_ms(20);
 }
 bufor[10] = I2C1_Rd(0);     //odczytujemy dane, nie potwierdzamy ACK
 Delay_ms(20);
 I2C1_Stop();                //wysyamy sygna STOP

 //wywietlamy pierwszy napis
  Lcd_Cmd(_LCD_CLEAR);       //reset wywietlacza LCD
  Lcd_Cmd(_LCD_CURSOR_OFF);  //wyczenie wywietlania kursora
  Lcd_Out(1, 4, bufor);      //wywietl tekst zaczynajc od 4 kolumny 1 wiersza
 /////////////////////////////////////////////////////
 //odczytujemy drugi napis
 I2C1_Start();               //wysyamy sygna START
 I2C1_Wr(0xA4);              //wysyamy pierwszy bajt (adres urzdzenia 0xA0, najst. bity adresu 2)
 I2C1_Wr(0);                 //wysyamy drugi bajt (adres pocztkowy w pamici EEPROM)
 I2C1_Repeated_Start();      //powtarzamy sygna START
 I2C1_Wr(0xA5);              //wysyamy adres urzdzenia (0xA4) z ustawionym bitem W
 for(k=0; k<13; k++)
 {
  bufor[k] = I2C1_Rd(1);     //odczytujemy dane, potwierdzamy ACK
  Delay_ms(20);
 }
 bufor[13] = I2C1_Rd(0);     //odczytujemy dane, nie potwierdzamy ACK
 Delay_ms(20);
 I2C1_Stop();                //wysyamy sygna STOP

 //wywietlamy drugi napis
  Lcd_Out(2, 2, bufor);      //wywietl tekst zaczynajc od 2 kolumny 2 wiersza
 /////////////////////////////////////////////////////
 //nieskoczona ptla
 for(;;);
}