;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   Schemat podcze programowanego ukadu
;
;                 +----v----+
;           MCLR [| 1     40|] 
;                [| 2     39|] 
;                [| 3     38|] 
;                [| 4     37|] 
;                [| 5     36|] 
;                [| 6     35|] 
;      D1 <- RA5 [| 7     34|] 
;                [| 8     33|] 
;                [| 9     32|] VDD
;                [|10     31|] VSS
;            VDD [|11     30|] 
;            VSS [|12     29|] 
;(20 MHz) / OSC1 [|13     28|]
;         \ OSC2 [|14     27|]
;                [|15     26|] 
;                [|16     25|] 
;                [|17     24|]
;                [|18     23|] 
;                [|19     22|] 
;                [|20     21|] 
;                 +---------+
;                 PIC16F877A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
#include <p16F877a.inc>

;ustawienia bitw konfiguracyjnych
__CONFIG _CP_OFF&_WDT_OFF&_BODEN_OFF&_PWRTE_OFF&_HS_OSC&_WRT_OFF&_LVP_OFF&_CPD_OFF

;program
	bsf	STATUS, 5	;ustaw 5. bit rejestru STATUS (przejd do banku 1)
	movlw	0x06	;przelij warto 0x06 do rejestru W
	movwf	ADCON1	;zaaduj rejestr ADCON1 wartoci z W (linie cyfrowe)
	movlw	0x00	;przelij warto 0x00 do rejestru W
	movwf	TRISA	;zaaduj rejestr TRISA wartoci z W (port A wyjciowy)
	
	bcf	STATUS, 5	;wyzeruj 5. bit rejestru STATUS (przejd do banku 0)
	bsf	PORTA, 5	;ustaw wysok warto logiczn na linii RA5 (zawie diod)

;ptla nieskoczona
petla:
	goto petla


	end
