/**************************************************************
   Schemat podcze programowanego ukadu

                 +----v----+
           MCLR [| 1     40|] 
                [| 2     39|] 
                [| 3     38|] RB5 -> DB4_LCD
                [| 4     37|] RB4 -> DB5_LCD
                [| 5     36|] RB3 -> DB6_LCD
                [| 6     35|] RB2 -> DB7_LCD
                [| 7     34|] RB1 -> RS_LCD
                [| 8     33|] RB0 -> EN_LCD
                [| 9     32|] VDD
                [|10     31|] VSS
            VDD [|11     30|] 
            VSS [|12     29|] 
(20 MHz) / OSC1 [|13     28|]
         \ OSC2 [|14     27|]
                [|15     26|] 
                [|16     25|] 
                [|17     24|] 
     SCL <- SCL [|18     23|] SDA <-> SDA
                [|19     22|] 
                [|20     21|]  
                 +---------+
                 PIC16F877A
***************************************************************/

//definiujemy szybko oscylatora dla funkcji __delay_
#define _XTAL_FREQ 20000000
#include <htc.h>
#include <stdlib.h>
#include <string.h>

#define TRIS_RS_LCD   TRISBbits.TRISB1
#define TRIS_EN_LCD   TRISBbits.TRISB0
#define TRIS_DB4_LCD  TRISBbits.TRISB5
#define TRIS_DB5_LCD  TRISBbits.TRISB4
#define TRIS_DB6_LCD  TRISBbits.TRISB3
#define TRIS_DB7_LCD  TRISBbits.TRISB2

#define RS_LCD   PORTBbits.RB1
#define EN_LCD   PORTBbits.RB0
#define DB4_LCD  PORTBbits.RB5
#define DB5_LCD  PORTBbits.RB4
#define DB6_LCD  PORTBbits.RB3
#define DB7_LCD  PORTBbits.RB2

#include "lcd.h"

//oscylator 20 MHz (FOSC_HS)
//watchdog wyczony (WDTE_OFF)
//wyczone LVP (Low-Voltage ICSP Programming) (LVP_OFF)
__CONFIG(FOSC_HS & WDTE_OFF & LVP_OFF);

char napis0[] = "Wcisnij S1";
char napis1[] = "Trwa pomiar...";
char napis2[] = "Wynik:";
char napisw[11];

//definiujemy zmienne dbajc o to, 
//by znalazy si w banku 0
volatile unsigned long int czas @ 0x40;
volatile unsigned long int czas_wzorcowy @ 0x44;
volatile unsigned int wypelniacz @ 0x3E;

void main()
{
	ADCON1 = 0x06;				//wyczenie linii analogowych 
                    			//(wszystkie linie cyfrowe)
	TRISDbits.TRISD2 = 1;		//linia RD2 wejciowa (linia pomiaru)
	TRISCbits.TRISC0 = 1;		//linia RC0 wejciowa (przycisk S1)
	TRISAbits.TRISA5 = 0;		//linia RA5 wyjciowa (dioda D1)
	PORTAbits.RA5 = 0;			//dioda zgaszona

	WlaczLCD();					//inicjalizacja wywietlacza LCD
	UstawKursorLCD(1, 4);		//wiersz 1 kolumna 3
	WyswietlLCD(napis0, 10);	//wywietl napis

	for(;;)						//ptla nieskoczona
	{	
		while(PORTCbits.RC0 == 1);//oczekiwanie na klawisz

		CzyscLCD();				//reset wywietlacza
		UstawKursorLCD(1, 2);	//wiersz 1 kolumna 2
		WyswietlLCD(napis1, 14);//wywietl napis

		//wyzerowanie zmiennych
		czas = 0;							
		czas_wzorcowy = 59999;	//czas pomiaru = 1 minuta

		//wykonaj pomiar
		#asm
		#include <caspic.h>
			//ustaw bank dla portu D (bank 0)
			banksel (PORTD)
			//tu rozpoczyna si ptla gwna	
			petla:
			//sprawd stan linii RD2
			btfsc	PORTD, 2	
			//jeli linia jest ustawiona
			//pomi inkrementacj czasu
			goto	bez_inkrementacji_czasu
			//inaczej inkrementuj zmienn czas
			incf	_czas, f
			btfsc	STATUS, 2
			incf	_czas+1, f
			btfsc	STATUS, 2
			incf	_czas+2, f
			btfsc	STATUS, 2
			incf	_czas+3, f
			nop
			nop
			//sygnalizacja poprawnoci dziaania ukadu
			bcf		PORTA, 5	//zga diod, gdy jasno
			goto	dekrementuj_czas_wzorcowy
			bez_inkrementacji_czasu:
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			//sygnalizacja poprawnoci dziaania ukadu
			bsf		PORTA, 5	//zawie diod, gdy ciemno
			dekrementuj_czas_wzorcowy:			
			//Wypeniacz czasu :)
			//Bez tego kodu ptla trwa 25 cykli maszynowych.
			//Wypenienie brakujcych 4975 cykli maszynowych
			//daje w sumie 5000 cykli maszynowych,
			//czyli 1 milisekund.
			////pocztek wypeniacza
			movlw	0x3					//W = 0x3
			movwf	_wypelniacz+1		//W -> wypelniacz[1]
			movlw	0x3B				//W = 0x3D
			movwf	_wypelniacz			//W -> wypelniacz[0]
			movlw	1					//W = 1
			petla_wypelniacza:
				subwf	_wypelniacz, f	//odejmij od bajtu 0. warto z rejestru W
				btfss	STATUS, 0		//pomi nast. instrukcj, jeli nie byo poyczki
				subwf	_wypelniacz+1, f//odejmij od R0 warto z rejestru W
				btfsc	STATUS, 0		//pomi nast. instrukcj, jeli bya poyczka
				goto	petla_wypelniacza	
			nop
			nop
			nop	
			////koniec wypeniacza
			movlw	1					//W = 1
			subwf	_czas_wzorcowy, f	//odejmij od bajtu 0. warto z rejestru W
			btfss	STATUS, 0			//pomi nast. instrukcj, jeli nie byo poyczki
			subwf	_czas_wzorcowy+1, f	//odejmij od bajtu 1. warto z rejestru W
			btfss	STATUS, 0			//pomi nast. instrukcj, jeli nie byo poyczki
			subwf	_czas_wzorcowy+2, f	//odejmij od bajtu 2. warto z rejestru W
			btfss	STATUS, 0			//pomi nast. instrukcj, jeli nie byo poyczki
			subwf	_czas_wzorcowy+3, f	//odejmij od R0 warto z rejestru W
			btfsc	STATUS, 0			//pomi nast. instrukcj, jeli bya poyczka
			goto	petla			
		#endasm		

		PORTAbits.RA5 = 0;					//zga diod po zakoczeniu pomiaru
		//wywietlenie wyniku
		ultoa(napisw, czas, 10);			//konwersja wyniku na napis
		CzyscLCD();							//reset wywietlacza
		WyswietlLCD(napis2, 6);				//wywietl napis
		UstawKursorLCD(1, 7);				//wiersz 1 kolumna 7			
		WyswietlLCD(napisw, strlen(napisw));//wywietl wynik
		UstawKursorLCD(2, 4);				//wiersz 2 kolumna 4
		WyswietlLCD(napis0, 10);			//wywietl napis
	}
}
