;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;argument przekazywany zmienn bajtow o nazwie "dane_do_wyslania"
Wyslij_do_LCD:
	bsf	PORT_EN_LCD, EN_LCD		;ustawienie EN
	;wysanie 4 najstarszych bitw danych
	bcf	PORT_DB7_LCD, DB7_LCD	;zeruj lini DB7_LCD
	bcf	PORT_DB6_LCD, DB6_LCD	;zeruj lini DB6_LCD
	bcf	PORT_DB5_LCD, DB5_LCD	;zeruj lini DB5_LCD
	bcf	PORT_DB4_LCD, DB4_LCD	;zeruj lini DB4_LCD
	btfsc	dane_do_wyslania, 7	;pomi nast. instrukcj, jeli bit 7. = 0
	bsf	PORT_DB7_LCD, DB7_LCD	;ustawj lini DB7_LCD
	btfsc	dane_do_wyslania, 6	;pomi nast. instrukcj, jeli bit 6. = 0
	bsf	PORT_DB6_LCD, DB6_LCD	;ustawj lini DB6_LCD
	btfsc	dane_do_wyslania, 5	;pomi nast. instrukcj, jeli bit 5. = 0
	bsf	PORT_DB5_LCD, DB5_LCD	;ustawj lini DB5_LCD
	btfsc	dane_do_wyslania, 4	;pomi nast. instrukcj, jeli bit 4. = 0
	bsf	PORT_DB4_LCD, DB4_LCD	;ustawj lini DB4_LCD
	
	call Czekaj_1us				;zaczekaj 1 us
	;potwierdzenie wysania danych (opadajcym zboczem EN)
	bcf	PORT_EN_LCD, EN_LCD		;wyzerowanie EN

	;zaczekaj 1 us
	call Czekaj_1us
	
	bsf	PORT_EN_LCD, EN_LCD		;ustawienie EN
	;wysanie 4 najmodszych bitw danych
	bcf	PORT_DB7_LCD, DB7_LCD	;zeruj lini DB7_LCD
	bcf	PORT_DB6_LCD, DB6_LCD	;zeruj lini DB6_LCD
	bcf	PORT_DB5_LCD, DB5_LCD	;zeruj lini DB5_LCD
	bcf	PORT_DB4_LCD, DB4_LCD	;zeruj lini DB4_LCD
	btfsc	dane_do_wyslania, 3	;pomi nast. instrukcj, jeli bit 3. = 0
	bsf	PORT_DB7_LCD, DB7_LCD	;ustawj lini DB7_LCD
	btfsc	dane_do_wyslania, 2	;pomi nast. instrukcj, jeli bit 2. = 0
	bsf	PORT_DB6_LCD, DB6_LCD	;ustawj lini DB6_LCD
	btfsc	dane_do_wyslania, 1	;pomi nast. instrukcj, jeli bit 1. = 0
	bsf	PORT_DB5_LCD, DB5_LCD	;ustawj lini DB5_LCD
	btfsc	dane_do_wyslania, 0	;pomi nast. instrukcj, jeli bit 0. = 0
	bsf	PORT_DB4_LCD, DB4_LCD	;ustawj lini DB4_LCD
	
	call Czekaj_1us				;zaczekaj 1 us
	;potwierdzenie wysania danych (opadajcym zboczem EN)
	bcf	PORT_EN_LCD, EN_LCD		;wyzerowanie EN

	;;;;;;;;;;;;;;;;;;;;;\
	movlw   0			; \
	movwf   R3			;  \
	movlw   0			;   \
	movwf   R2			;    \
	movlw   0			;     >zaczekaj 40 us
	movwf   R1			;    /
	movlw   4			;   /
	movwf   R0			;  /
	call 	Czekaj_10us	; /
	;;;;;;;;;;;;;;;;;;;;;/

	return	;powrt z podprogramu
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
CzyscLCD:
	bcf	PORT_RS_LCD, RS_LCD	;zeruj lini RS_LCD (wysyamy rozkaz)
	;zaaduj argument dla podprogramu
	movlw	1
	movwf	dane_do_wyslania
	;skocz do podprogramu
	call	Wyslij_do_LCD
	bsf	PORT_RS_LCD, RS_LCD	;ustaw lini RS_LCD 

	;;;;;;;;;;;;;;;;;;;;;\
	movlw   0			; \
	movwf   R3			;  \
	movlw   0			;   \
	movwf   R2			;    \
	movlw   0			;     >zaczekaj 1,64 ms
	movwf   R1			;    /
	movlw   0xA4		;   /
	movwf   R0			;  /
	call 	Czekaj_10us	; /
	;;;;;;;;;;;;;;;;;;;;;/
	 
	return	;powrt z podprogramu
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
WlaczLCD:
	;ustawienie kierunku wyjciowego linii podczonych do LCD
	;(pamitajmy o konfiguracji linii cyfrowych, jeli korzystamy z linii analogowych)
	bsf	STATUS, 5		;ustaw 5. bit rejestru STATUS (przejd do banku 1.)
	bcf	TRIS_RS_LCD, RS_LCD	
	bcf	TRIS_EN_LCD, EN_LCD	
	bcf	TRIS_DB7_LCD, DB7_LCD	
	bcf	TRIS_DB6_LCD, DB6_LCD	
	bcf	TRIS_DB5_LCD, DB5_LCD	
	bcf	TRIS_DB4_LCD, DB4_LCD	
	bcf	STATUS, 5		;wyzeruj 5. bit rejestru STATUS (przejd do banku 0)

	;stan niski na liniach
	bcf	PORT_RS_LCD, RS_LCD	
	bcf	PORT_EN_LCD, EN_LCD	
	bcf	PORT_DB7_LCD, DB7_LCD	
	bcf	PORT_DB6_LCD, DB6_LCD	
	bcf	PORT_DB5_LCD, DB5_LCD	
	bcf	PORT_DB4_LCD, DB4_LCD	

	;zaczekaj co najmniej 45 ms na ustabilizowanie si napicia
	;;;;;;;;;;;;;;;;;;;;;\
	movlw   0			; \
	movwf   R3			;  \
	movlw   0			;   \
	movwf   R2			;    \
	movlw   0x11		;     >
	movwf   R1			;    /
	movlw   0x94		;   /
	movwf   R0			;  /
	call 	Czekaj_10us	; /
	;;;;;;;;;;;;;;;;;;;;;/

	;1
	;ustaw lini EN
	bsf	PORT_EN_LCD, EN_LCD
	;zaaduj sekwencj 0011
	bcf	PORT_DB7_LCD, DB7_LCD	;zeruj lini DB7_LCD
	bcf	PORT_DB6_LCD, DB6_LCD	;zeruj lini DB6_LCD
	bsf	PORT_DB5_LCD, DB5_LCD	;ustaw lini DB5_LCD
	bsf	PORT_DB4_LCD, DB4_LCD	;ustaw lini DB4_LCD
	;zaczekaj 1 us
	call	Czekaj_1us
	;potwierd opadajcym zboczem EN
	bcf	PORT_EN_LCD, EN_LCD

	;zaczekaj co najmniej 4,1 ms
	;;;;;;;;;;;;;;;;;;;;;\
	movlw   0			; \
	movwf   R3			;  \
	movlw   0			;   \
	movwf   R2			;    \
	movlw   1			;     >
	movwf   R1			;    /
	movlw   0x9A		;   /
	movwf   R0			;  /
	call 	Czekaj_10us	; /
	;;;;;;;;;;;;;;;;;;;;;/


	;2
	;ustaw lini EN
	bsf	PORT_EN_LCD, EN_LCD
	;zaczekaj 1 us
	call Czekaj_1us
	;potwierd opadajcym zboczem EN sekwencj 0011
	bcf	PORT_EN_LCD, EN_LCD
	
	;zaczekaj co najmniej 100 us
	;;;;;;;;;;;;;;;;;;;;;\
	movlw   0			; \
	movwf   R3			;  \
	movlw   0			;   \
	movwf   R2			;    \
	movlw   0			;     >
	movwf   R1			;    /
	movlw   d'10'		;   /
	movwf   R0			;  /
	call 	Czekaj_10us	; /
	;;;;;;;;;;;;;;;;;;;;;/
	
	;3
	;ustaw lini EN
	bsf	PORT_EN_LCD, EN_LCD
	;zaczekaj 1 us
	call Czekaj_1us
	;potwierd opadajcym zboczem EN sekwencj 0011
	bcf	PORT_EN_LCD, EN_LCD
	
	;zaczekaj co najmniej 100 us
	;;;;;;;;;;;;;;;;;;;;;\
	movlw   0			; \
	movwf   R3			;  \
	movlw   0			;   \
	movwf   R2			;    \
	movlw   0			;     >
	movwf   R1			;    /
	movlw   d'10'		;   /
	movwf   R0			;  /
	call 	Czekaj_10us	; /
	;;;;;;;;;;;;;;;;;;;;;/
 
	;4
	;ustaw lini EN
	bsf	PORT_EN_LCD, EN_LCD
	;ustawienie interfejsu 4-bitowego
	bcf	PORT_DB4_LCD, DB4_LCD
	;zaczekaj 1 us
	call Czekaj_1us
	;potwierd opadajcym zboczem EN
	bcf	PORT_EN_LCD, EN_LCD

	;ustaw parametry wywietlacza
	;bit 4 = 0 (sowo danych ma 4 bity)
	;bit 3 = 1 (2 wiersze znakw)
	;bit 2 = 0 (matryca 5x8 pikseli)
	bcf	PORT_RS_LCD, RS_LCD
	;zaaduj argument dla podprogramu
	movlw	b'00101000'
	movwf	dane_do_wyslania
	;skocz do podprogramu
	call	Wyslij_do_LCD
	bsf	PORT_RS_LCD, RS_LCD

	;wcz wywietlacz
	;bit 2 = 1 (wczenie wywietlania)
	;bit 1 = 0 (kursor nieaktywny)
	;bit 0 = 0 (kursor nie miga)
	bcf	PORT_RS_LCD, RS_LCD
	;zaaduj argument dla podprogramu
	movlw	b'00001100'
	movwf	dane_do_wyslania
	;skocz do podprogramu
	call	Wyslij_do_LCD
	bsf	PORT_RS_LCD, RS_LCD

	;ustaw tryb pracy wywietlacza
	;bit 2 = 1 (inkrementowanie adresu zapisu danych)
	;bit 1 = 1 (wyczenie przesuwania w prawo)
	bcf	PORT_RS_LCD, RS_LCD
	;zaaduj argument dla podprogramu
	movlw	b'00000110'
	movwf	dane_do_wyslania
	;skocz do podprogramu
	call	Wyslij_do_LCD
	bsf	PORT_RS_LCD, RS_LCD

	call CzyscLCD
	return	;powrt z podprogramu
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;argumenty dla podprogramu:
;napis - adres cigu znakw (max. 16 bajtw) do wywietlenia (0x20)
;ile - liczba znakw do wywietlenia
WyswietlLCD:
	bcf	STATUS, 7	;zeruj bit IRP rejestru STATUS (adres banku 0)
	movlw	0x20	;adres zmiennej napis
	movwf	FSR		;adujemy do rejestru FSR
petla_wyswietlLCD:
	;zaaduj argument dla podprogramu 
	;(adresowanie porednie - adres w FSR)
	movf	INDF, 0	;zaaduj bajt spod adresu FSR do W
	movwf	dane_do_wyslania	;zaaduj W do argumentu podprogramu
	;skocz do podprogramu
	call	Wyslij_do_LCD
	;inkrementuj adres
	incf	FSR, 1
	;zmniejsz licznik znakw, pomi skok, jeli jest 0
	decfsz	ile, 1
	goto	petla_wyswietlLCD

	return	;powrt z podprogramu
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;argumenty dla podprogramu:
;y - wiersz wywietlacza
;x - kolumna qywietlacza
UstawKursorLCD:
	;ustal nowy adres pamici DD RAM
	decf	x, 1		;x = x - 1
	decf	y, 1		;y = y - 1
	movf	y, 0		;y -> W
	btfss	STATUS, 2	;pomi nast. instrukcj, jeli W = 0
	addlw	0x40		;W = W + 0x40
	addwf	x, 0		;W = W + x

	;ustaw kod
	iorlw	b'10000000'	;najstarszy bit danych ustawiony
	
	;wylij rozkaz ustawienia nowego adresu DD RAM
	bcf	PORT_RS_LCD, RS_LCD
	movwf	dane_do_wyslania
	call	Wyslij_do_LCD
	bsf	PORT_RS_LCD, RS_LCD
	
	return	;powrt z podprogramu
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

