/**************************************************************
   Schemat podcze programowanego ukadu

                 +----v----+
           MCLR [| 1     40|] 
                [| 2     39|] 
                [| 3     38|] 
                [| 4     37|] 
                [| 5     36|] 
                [| 6     35|] 
                [| 7     34|] 
                [| 8     33|] 
                [| 9     32|] VDD
                [|10     31|] VSS
            VDD [|11     30|] 
            VSS [|12     29|] 
(20 MHz) / OSC1 [|13     28|]
         \ OSC2 [|14     27|]
                [|15     26|] 
                [|16     25|] 
                [|17     24|]
                [|18     23|] 
                [|19     22|] 
   serwo <- RD1 [|20     21|] 
                 +---------+
                 PIC16F877A
***************************************************************/

#include <htc.h>
//definiujemy szybko oscylatora dla funkcji __delay_
#define _XTAL_FREQ 20000000

//oscylator szybszy od 10 MHz (FOSC_HS)
//watchdog wyczony (WDTE_OFF)
//wyczone LVP (Low-Voltage ICSP Programming) (LVP_OFF)
__CONFIG(FOSC_HS & WDTE_OFF & LVP_OFF);

void main()
{
	unsigned char i, j;
	ADCON1 = 0x06;			//wyczenie linii analogowych 
                    		//(wszystkie linie cyfrowe)
	TRISDbits.TRISD1 = 0;	//linia RD1 wyjciowa

	for(;;)					//ptla nieskoczona
	{
		//przesu rami serwomechanizmu do pozycji 0 stopni
		for(i=0; i<80; i++)
		{
			PORTDbits.RD1 = 1;	//impuls na linii RD1
			__delay_us(500);	//czekaj 0,5 ms
			PORTDbits.RD1 = 0;	//wycz lini RD1
			__delay_ms(15);		//czekaj 15 ms
		}

		//przesu rami serwomechanizmu do pozycji 180 stopni
		for(j=0; j<80; j++)
		{
			PORTDbits.RD1 = 1;	//impuls na linii RD1
			__delay_us(2500);	//czekaj 2,5 ms
			PORTDbits.RD1 = 0;	//wycz lini RD1
			__delay_ms(15);		//czekaj 15 ms
		}
	}
}
