# Romanian (ro) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                   | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987                                              | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                 | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987                                              | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                 | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                 | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | T1                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | T2                                                | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | primul trimestru                                  | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | al doilea trimestru                               | Invalid Date             |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                 | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                 | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | T1                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | T2                                                | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | primul trimestru                                  | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | al doilea trimestru                               | Invalid Date             |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                 | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | feb                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | iul                                               | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | februarie                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | iulie                                             | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | F                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | I                                                 | 2019-01-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                 | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | feb                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | iul                                               | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | februarie                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | iulie                                             | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | F                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | I                                                 | 2019-01-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1                                                 | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                                | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1                                                 | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                                | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28                                                | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365                                               | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | lun                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vin                                               | Invalid Date             |
|                                 | EE           | 2019-02-11T12:13:14.015Z | lun                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vin                                               | Invalid Date             |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | lun                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vin                                               | Invalid Date             |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | luni                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vineri                                            | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | l                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | v                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | lu                                                | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | vi                                                | Invalid Date             |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | lun                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vin                                               | Invalid Date             |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | luni                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vineri                                            | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | l                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | v                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | lu                                                | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | vi                                                | Invalid Date             |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                 | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | lun                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vin                                               | Invalid Date             |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | luni                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vineri                                            | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | l                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | v                                                 | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | lu                                                | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | vi                                                | Invalid Date             |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                 | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | lun                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vin                                               | Invalid Date             |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | luni                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vineri                                            | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | l                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | v                                                 | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | lu                                                | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | vi                                                | Invalid Date             |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | a.m.                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                              | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | a                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                                 | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | a.m.                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                              | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | a                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                                 | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | dimineață                                         | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | după-amiază                                       | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | seară                                             | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | noapte                                            | Invalid Date             |
|                                 | BB           | 2019-02-11T11:13:14.015Z | dimineață                                         | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | după-amiază                                       | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | seară                                             | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | noapte                                            | Invalid Date             |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | dimineață                                         | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | după-amiază                                       | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | seară                                             | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | noapte                                            | Invalid Date             |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | dimineață                                         | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | după-amiază                                       | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | seară                                             | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | noapte                                            | Invalid Date             |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | dimineață                                         | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | după-amiază                                       | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | seară                                             | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | noapte                                            | Invalid Date             |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1                                                 | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55                                                | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1                                                 | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55                                                | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11/02/1987                                        | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453                                        | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11 feb 1987                                       | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 mai 1453                                       | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11 februarie 1987                                 | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 mai 1453                                       | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | miercuri, 11 februarie 1987                       | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | duminică, 29 mai 1453                             | Invalid Date             |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                             | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                             | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                          | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                          | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                    | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                                | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11/02/1987, 12:13                                 | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453, 23:59                                 | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11 feb 1987, 12:13:14                             | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 mai 1453, 23:59:59                             | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11 februarie 1987 la 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 mai 1453 la 23:59:59 GMT+0                     | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | miercuri, 11 februarie 1987 la 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | duminică, 29 mai 1453 la 23:59:59 GMT+00:00       | Invalid Date             |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result                | `includeSeconds: true`  | `addSuffix: true`             |
| ------------------------ | --------------------- | ----------------------- | ----------------------------- |
| 2006-01-01T00:00:00.000Z | circa 6 ani           | circa 6 ani             | în circa 6 ani                |
| 2005-01-01T00:00:00.000Z | circa 5 ani           | circa 5 ani             | în circa 5 ani                |
| 2004-01-01T00:00:00.000Z | circa 4 ani           | circa 4 ani             | în circa 4 ani                |
| 2003-01-01T00:00:00.000Z | circa 3 ani           | circa 3 ani             | în circa 3 ani                |
| 2002-01-01T00:00:00.000Z | circa 2 ani           | circa 2 ani             | în circa 2 ani                |
| 2001-06-01T00:00:00.000Z | peste 1 an            | peste 1 an              | în peste 1 an                 |
| 2001-02-01T00:00:00.000Z | circa 1 an            | circa 1 an              | în circa 1 an                 |
| 2001-01-01T00:00:00.000Z | circa 1 an            | circa 1 an              | în circa 1 an                 |
| 2000-06-01T00:00:00.000Z | 5 luni                | 5 luni                  | în 5 luni                     |
| 2000-03-01T00:00:00.000Z | 2 luni                | 2 luni                  | în 2 luni                     |
| 2000-02-01T00:00:00.000Z | circa 1 lună          | circa 1 lună            | în circa 1 lună               |
| 2000-01-15T00:00:00.000Z | 14 zile               | 14 zile                 | în 14 zile                    |
| 2000-01-02T00:00:00.000Z | 1 zi                  | 1 zi                    | în 1 zi                       |
| 2000-01-01T06:00:00.000Z | circa 6 ore           | circa 6 ore             | în circa 6 ore                |
| 2000-01-01T01:00:00.000Z | circa 1 oră           | circa 1 oră             | în circa 1 oră                |
| 2000-01-01T00:45:00.000Z | circa 1 oră           | circa 1 oră             | în circa 1 oră                |
| 2000-01-01T00:30:00.000Z | 30 minute             | 30 minute               | în 30 minute                  |
| 2000-01-01T00:15:00.000Z | 15 minute             | 15 minute               | în 15 minute                  |
| 2000-01-01T00:01:00.000Z | 1 minut               | 1 minut                 | în 1 minut                    |
| 2000-01-01T00:00:25.000Z | mai puțin de un minut | jumătate de minut       | în mai puțin de un minut      |
| 2000-01-01T00:00:15.000Z | mai puțin de un minut | mai puțin de 20 secunde | în mai puțin de un minut      |
| 2000-01-01T00:00:05.000Z | mai puțin de un minut | mai puțin de 10 secunde | în mai puțin de un minut      |
| 2000-01-01T00:00:00.000Z | mai puțin de un minut | mai puțin de 5 secunde  | mai puțin de un minut în urmă |
| 1999-12-31T23:59:55.000Z | mai puțin de un minut | mai puțin de 10 secunde | mai puțin de un minut în urmă |
| 1999-12-31T23:59:45.000Z | mai puțin de un minut | mai puțin de 20 secunde | mai puțin de un minut în urmă |
| 1999-12-31T23:59:35.000Z | mai puțin de un minut | jumătate de minut       | mai puțin de un minut în urmă |
| 1999-12-31T23:59:00.000Z | 1 minut               | 1 minut                 | 1 minut în urmă               |
| 1999-12-31T23:45:00.000Z | 15 minute             | 15 minute               | 15 minute în urmă             |
| 1999-12-31T23:30:00.000Z | 30 minute             | 30 minute               | 30 minute în urmă             |
| 1999-12-31T23:15:00.000Z | circa 1 oră           | circa 1 oră             | circa 1 oră în urmă           |
| 1999-12-31T23:00:00.000Z | circa 1 oră           | circa 1 oră             | circa 1 oră în urmă           |
| 1999-12-31T18:00:00.000Z | circa 6 ore           | circa 6 ore             | circa 6 ore în urmă           |
| 1999-12-30T00:00:00.000Z | 2 zile                | 2 zile                  | 2 zile în urmă                |
| 1999-12-15T00:00:00.000Z | 17 zile               | 17 zile                 | 17 zile în urmă               |
| 1999-12-01T00:00:00.000Z | circa 1 lună          | circa 1 lună            | circa 1 lună în urmă          |
| 1999-11-01T00:00:00.000Z | 2 luni                | 2 luni                  | 2 luni în urmă                |
| 1999-06-01T00:00:00.000Z | 7 luni                | 7 luni                  | 7 luni în urmă                |
| 1999-01-01T00:00:00.000Z | circa 1 an            | circa 1 an              | circa 1 an în urmă            |
| 1998-12-01T00:00:00.000Z | circa 1 an            | circa 1 an              | circa 1 an în urmă            |
| 1998-06-01T00:00:00.000Z | peste 1 an            | peste 1 an              | peste 1 an în urmă            |
| 1998-01-01T00:00:00.000Z | circa 2 ani           | circa 2 ani             | circa 2 ani în urmă           |
| 1997-01-01T00:00:00.000Z | circa 3 ani           | circa 3 ani             | circa 3 ani în urmă           |
| 1996-01-01T00:00:00.000Z | circa 4 ani           | circa 4 ani             | circa 4 ani în urmă           |
| 1995-01-01T00:00:00.000Z | circa 5 ani           | circa 5 ani             | circa 5 ani în urmă           |
| 1994-01-01T00:00:00.000Z | circa 6 ani           | circa 6 ani             | circa 6 ani în urmă           |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result     | `addSuffix: true`  | With forced unit (i.e. `hour`) |
| ------------------------ | ---------- | ------------------ | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 ani      | în 6 ani           | 52608 ore                      |
| 2005-01-01T00:00:00.000Z | 5 ani      | în 5 ani           | 43848 ore                      |
| 2004-01-01T00:00:00.000Z | 4 ani      | în 4 ani           | 35064 ore                      |
| 2003-01-01T00:00:00.000Z | 3 ani      | în 3 ani           | 26304 ore                      |
| 2002-01-01T00:00:00.000Z | 2 ani      | în 2 ani           | 17544 ore                      |
| 2001-06-01T00:00:00.000Z | 1 an       | în 1 an            | 12408 ore                      |
| 2001-02-01T00:00:00.000Z | 1 an       | în 1 an            | 9528 ore                       |
| 2001-01-01T00:00:00.000Z | 1 an       | în 1 an            | 8784 ore                       |
| 2000-06-01T00:00:00.000Z | 5 luni     | în 5 luni          | 3648 ore                       |
| 2000-03-01T00:00:00.000Z | 2 luni     | în 2 luni          | 1440 ore                       |
| 2000-02-01T00:00:00.000Z | 1 lună     | în 1 lună          | 744 ore                        |
| 2000-01-15T00:00:00.000Z | 14 zile    | în 14 zile         | 336 ore                        |
| 2000-01-02T00:00:00.000Z | 1 zi       | în 1 zi            | 24 ore                         |
| 2000-01-01T06:00:00.000Z | 6 ore      | în 6 ore           | 6 ore                          |
| 2000-01-01T01:00:00.000Z | 1 oră      | în 1 oră           | 1 oră                          |
| 2000-01-01T00:45:00.000Z | 45 minute  | în 45 minute       | 1 oră                          |
| 2000-01-01T00:30:00.000Z | 30 minute  | în 30 minute       | 1 oră                          |
| 2000-01-01T00:15:00.000Z | 15 minute  | în 15 minute       | 0 ore                          |
| 2000-01-01T00:01:00.000Z | 1 minut    | în 1 minut         | 0 ore                          |
| 2000-01-01T00:00:25.000Z | 25 secunde | în 25 secunde      | 0 ore                          |
| 2000-01-01T00:00:15.000Z | 15 secunde | în 15 secunde      | 0 ore                          |
| 2000-01-01T00:00:05.000Z | 5 secunde  | în 5 secunde       | 0 ore                          |
| 2000-01-01T00:00:00.000Z | 0 secunde  | 0 secunde în urmă  | 0 ore                          |
| 1999-12-31T23:59:55.000Z | 5 secunde  | 5 secunde în urmă  | 0 ore                          |
| 1999-12-31T23:59:45.000Z | 15 secunde | 15 secunde în urmă | 0 ore                          |
| 1999-12-31T23:59:35.000Z | 25 secunde | 25 secunde în urmă | 0 ore                          |
| 1999-12-31T23:59:00.000Z | 1 minut    | 1 minut în urmă    | 0 ore                          |
| 1999-12-31T23:45:00.000Z | 15 minute  | 15 minute în urmă  | 0 ore                          |
| 1999-12-31T23:30:00.000Z | 30 minute  | 30 minute în urmă  | 1 oră                          |
| 1999-12-31T23:15:00.000Z | 45 minute  | 45 minute în urmă  | 1 oră                          |
| 1999-12-31T23:00:00.000Z | 1 oră      | 1 oră în urmă      | 1 oră                          |
| 1999-12-31T18:00:00.000Z | 6 ore      | 6 ore în urmă      | 6 ore                          |
| 1999-12-30T00:00:00.000Z | 2 zile     | 2 zile în urmă     | 48 ore                         |
| 1999-12-15T00:00:00.000Z | 17 zile    | 17 zile în urmă    | 408 ore                        |
| 1999-12-01T00:00:00.000Z | 1 lună     | 1 lună în urmă     | 744 ore                        |
| 1999-11-01T00:00:00.000Z | 2 luni     | 2 luni în urmă     | 1464 ore                       |
| 1999-06-01T00:00:00.000Z | 7 luni     | 7 luni în urmă     | 5136 ore                       |
| 1999-01-01T00:00:00.000Z | 1 an       | 1 an în urmă       | 8760 ore                       |
| 1998-12-01T00:00:00.000Z | 1 an       | 1 an în urmă       | 9504 ore                       |
| 1998-06-01T00:00:00.000Z | 2 ani      | 2 ani în urmă      | 13896 ore                      |
| 1998-01-01T00:00:00.000Z | 2 ani      | 2 ani în urmă      | 17520 ore                      |
| 1997-01-01T00:00:00.000Z | 3 ani      | 3 ani în urmă      | 26280 ore                      |
| 1996-01-01T00:00:00.000Z | 4 ani      | 4 ani în urmă      | 35064 ore                      |
| 1995-01-01T00:00:00.000Z | 5 ani      | 5 ani în urmă      | 43824 ore                      |
| 1994-01-01T00:00:00.000Z | 6 ani      | 6 ani în urmă      | 52584 ore                      |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                     |
| ------------------------ | -------------------------- |
| 2000-01-10T00:00:00.000Z | 10/01/2000                 |
| 2000-01-05T00:00:00.000Z | miercuri viitoare la 00:00 |
| 2000-01-02T00:00:00.000Z | mâine la 00:00             |
| 2000-01-01T00:00:00.000Z | astăzi la 00:00            |
| 1999-12-31T00:00:00.000Z | ieri la 00:00              |
| 1999-12-27T00:00:00.000Z | luni trecută la 00:00      |
| 1999-12-21T00:00:00.000Z | 21/12/1999                 |
