/*
 * ILI_parallel.c
 *
 * Created: 2017-04-15 10:52:41
 * Author : tmf
 */ 

#include "sam.h"
#include <stdbool.h>
#include <stdlib.h>
#include <stdio.h>
#include "Clk/SetClk.h"
#include "Delay/delay.h"

#include "GFXDrv.h"
#include "i8080-arm.h"
#include "RA8875.h"
#include "Fonts/Fonts.h"
#include "Icons.h"

void RA_SetGraphCursorPos(uint16_t x, uint16_t y)
{
	RA_SendCmdWithDataW(RA_Graphic_Cursor_Horizontal_Position_Register0, x);
	RA_SendCmdWithDataW(RA_Graphic_Cursor_Vertical_Position_Register0, y);
}

void RA_SetGraphCursorColor(uint8_t col1, uint8_t col2)
{
	RA_SendCmdWithData(RA_Graphic_Cursor_Color0, col1);
	RA_SendCmdWithData(RA_Graphic_Cursor_Color1, col2);
}

void RA_SetCurShape(uint8_t curType, const uint8_t *data)
{
	RS8875_MWCR1_Reg tmpMMCR, MMCR;
	tmpMMCR.byte=RA_SendCmdReadData(RA_Memory_Write_Control_Register1);
	MMCR.byte=tmpMMCR.byte;
	MMCR.CursorType=curType;
	MMCR.Memory=RA_DestWriteGraphicCursor;
	RA_SendCmdWithData(RA_Memory_Write_Control_Register1, MMCR.byte);  //Wybierz do zapisu pami kursora
	
	LCD_SendCmd(RA_Memory_Read_Write_Command);     //Rozpocznij wpisywanie 256 bajtw danych o kursorze
	for(uint16_t ind=0; ind < 256; ind++) i8080_Write_B(*data++);
	RA_SendCmdWithData(RA_Memory_Write_Control_Register1, tmpMMCR.byte);	//Odtwrz rejestr MMCR1
}

void RA_GraphCursorEn(_Bool en, uint8_t curType)
{
	RS8875_MWCR1_Reg tmpMMCR;
	tmpMMCR.byte=RA_SendCmdReadData(RA_Memory_Write_Control_Register1);
	tmpMMCR.GrCursorEn=en;
	tmpMMCR.CursorType=curType;
	RA_SendCmdWithData(RA_Memory_Write_Control_Register1, tmpMMCR.byte);
}

const uint8_t image_data_c1[256] = {
	0xaa, 0xaa, 0xaa, 0xaa, 0x9a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa9, 0x7e,
	0x40, 0xda, 0xaa, 0xaa, 0xaa, 0xaa, 0x9f, 0x5e, 0x40, 0x01, 0xaa, 0xaa,
	0xaa, 0xa9, 0xd5, 0x5e, 0x40, 0x00, 0x2a, 0xaa, 0xaa, 0xa7, 0x55, 0x5e,
	0x40, 0x00, 0x0a, 0xaa, 0xaa, 0x95, 0x55, 0x5e, 0x40, 0x00, 0x02, 0xaa,
	0xaa, 0x55, 0x55, 0xd6, 0x80, 0x00, 0x00, 0xaa, 0xa9, 0xd5, 0x5d, 0xaa,
	0xa9, 0x00, 0x00, 0x2a, 0xaa, 0x75, 0x7a, 0xaa, 0xaa, 0x90, 0x03, 0xaa,
	0xa6, 0xa7, 0xea, 0xaa, 0xaa, 0xa4, 0x0a, 0x9a, 0xaf, 0x6a, 0xaa, 0xaa,
	0xaa, 0xa9, 0x69, 0xfa, 0x9d, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x76,
	0x95, 0x5e, 0xaa, 0xaa, 0xaa, 0xaa, 0xb5, 0x56, 0xb5, 0x56, 0xaa, 0xaa,
	0xaa, 0xaa, 0x95, 0x5e, 0xb5, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x5e,
	0xb5, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x5e, 0xb5, 0x76, 0xaa, 0xaa,
	0xaa, 0xaa, 0x9d, 0x5e, 0xb5, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x5e,
	0xb5, 0x56, 0xaa, 0xaa, 0xaa, 0xaa, 0x95, 0x5e, 0x95, 0x5e, 0xaa, 0xaa,
	0xaa, 0xaa, 0xb5, 0x56, 0x9d, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x76,
	0xaf, 0x6a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa9, 0xfa, 0xa6, 0xa7, 0xea, 0xaa,
	0xaa, 0xab, 0xda, 0x9a, 0xaa, 0x7d, 0x7a, 0xaa, 0xaa, 0xad, 0x7d, 0xaa,
	0xa9, 0xd5, 0x5d, 0xaa, 0xaa, 0x75, 0x57, 0x6a, 0xaa, 0x55, 0x55, 0xd6,
	0x97, 0x55, 0x55, 0xaa, 0xaa, 0x95, 0x55, 0x5e, 0xb5, 0x55, 0x56, 0xaa,
	0xaa, 0xa7, 0x55, 0x5e, 0xb5, 0x55, 0xda, 0xaa, 0xaa, 0xa9, 0xd5, 0x5e,
	0xb5, 0x57, 0x6a, 0xaa, 0xaa, 0xaa, 0x9f, 0x5e, 0xb5, 0xf6, 0xaa, 0xaa,
	0xaa, 0xaa, 0xa9, 0x7e, 0xbd, 0x6a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
	0xaa, 0xaa, 0xaa, 0xaa
};

const uint8_t image_data_c2[256] = {
	0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa9, 0x7e,
	0xbd, 0x6a, 0xaa, 0xaa, 0xaa, 0xaa, 0x9f, 0x5e, 0xb5, 0xf6, 0xaa, 0xaa,
	0xaa, 0xa9, 0xd5, 0x5e, 0xb5, 0x57, 0x6a, 0xaa, 0xaa, 0xa7, 0x55, 0x5e,
	0xb5, 0x55, 0xda, 0xaa, 0xaa, 0x95, 0x55, 0x5e, 0xb5, 0x55, 0x56, 0xaa,
	0xaa, 0x55, 0x55, 0xd6, 0x97, 0xd5, 0x55, 0xaa, 0xa9, 0xd5, 0x5d, 0xaa,
	0xaa, 0x75, 0x57, 0x6a, 0xaa, 0x7d, 0x7a, 0xaa, 0xaa, 0xad, 0x5d, 0xaa,
	0xa5, 0xa7, 0xea, 0xaa, 0xaa, 0xab, 0xda, 0x4a, 0xaf, 0x6a, 0xaa, 0xaa,
	0xaa, 0xaa, 0xa4, 0x06, 0x9d, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x80, 0x02,
	0x95, 0x5e, 0xaa, 0xaa, 0xaa, 0xaa, 0x40, 0x02, 0xb5, 0x56, 0xaa, 0xaa,
	0xaa, 0xaa, 0x80, 0x02, 0xb5, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x80, 0x01,
	0xb5, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0xb0, 0x01, 0xb5, 0x76, 0xaa, 0xaa,
	0xaa, 0xaa, 0xb0, 0x01, 0xb5, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x80, 0x01,
	0xb5, 0x56, 0xaa, 0xaa, 0xaa, 0xaa, 0x80, 0x02, 0x95, 0x5e, 0xaa, 0xaa,
	0xaa, 0xaa, 0x40, 0x02, 0x9d, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x80, 0x02,
	0xaf, 0x6a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4, 0x06, 0xa5, 0xa7, 0xea, 0xaa,
	0xaa, 0xab, 0xda, 0x4a, 0xaa, 0x75, 0x7a, 0xaa, 0xaa, 0xad, 0x5d, 0xaa,
	0xa9, 0xd5, 0x5d, 0xaa, 0xaa, 0x75, 0x57, 0x6a, 0xaa, 0x55, 0x55, 0xd6,
	0x97, 0x55, 0x55, 0xaa, 0xaa, 0x95, 0x55, 0x5e, 0xb5, 0x55, 0x56, 0xaa,
	0xaa, 0xa7, 0x55, 0x5e, 0xb5, 0x55, 0xda, 0xaa, 0xaa, 0xa9, 0xd5, 0x5e,
	0xb5, 0x57, 0x6a, 0xaa, 0xaa, 0xaa, 0x9f, 0x5e, 0xb5, 0xf6, 0xaa, 0xaa,
	0xaa, 0xaa, 0xa9, 0x7e, 0xbd, 0x6a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
	0xaa, 0xaa, 0xaa, 0xaa
};

const uint8_t image_data_c3[256] = {
	0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa9, 0x7e,
	0xbd, 0x6a, 0xaa, 0xaa, 0xaa, 0xaa, 0x9f, 0x5e, 0xb5, 0xf6, 0xaa, 0xaa,
	0xaa, 0xa9, 0xd5, 0x5e, 0xb5, 0x57, 0x6a, 0xaa, 0xaa, 0xa7, 0x55, 0x5e,
	0xb5, 0x55, 0xda, 0xaa, 0xaa, 0x95, 0x55, 0x5e, 0xb5, 0x55, 0x5e, 0xaa,
	0xaa, 0x55, 0x55, 0xd6, 0x97, 0x55, 0x55, 0xaa, 0xa9, 0xd5, 0x5d, 0xaa,
	0xaa, 0x75, 0x57, 0x6a, 0xaa, 0x75, 0x7a, 0xaa, 0xaa, 0xad, 0x5d, 0xaa,
	0xa5, 0xa7, 0xea, 0xaa, 0xaa, 0xab, 0xda, 0x5a, 0xaf, 0x6a, 0xaa, 0xaa,
	0xaa, 0xaa, 0xa9, 0xfa, 0x95, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x76,
	0x95, 0x5e, 0xaa, 0xaa, 0xaa, 0xaa, 0xb5, 0x56, 0xb5, 0x56, 0xaa, 0xaa,
	0xaa, 0xaa, 0x95, 0x5e, 0xb5, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x5e,
	0xb5, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x5e, 0xb5, 0x76, 0xaa, 0xaa,
	0xaa, 0xaa, 0x9d, 0x5e, 0xb5, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x5e,
	0xb5, 0x56, 0xaa, 0xaa, 0xaa, 0xaa, 0x95, 0x5e, 0x95, 0x5e, 0xaa, 0xaa,
	0xaa, 0xaa, 0xb5, 0x56, 0x9d, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x76,
	0xaf, 0x6a, 0xaa, 0xaa, 0xaa, 0xa9, 0x69, 0xfa, 0xa5, 0xa7, 0xea, 0xaa,
	0xaa, 0xa4, 0x0a, 0x9a, 0xaa, 0x75, 0x7a, 0xaa, 0xaa, 0x90, 0x03, 0xaa,
	0xa9, 0xd5, 0x5d, 0xaa, 0xa9, 0x00, 0x00, 0x2a, 0xaa, 0x55, 0x55, 0xd6,
	0x80, 0x00, 0x00, 0xaa, 0xaa, 0x95, 0x55, 0x5e, 0x40, 0x00, 0x02, 0xaa,
	0xaa, 0xa7, 0x55, 0x5e, 0x40, 0x00, 0x0a, 0xaa, 0xaa, 0xa9, 0xd5, 0x5e,
	0x40, 0x00, 0x2a, 0xaa, 0xaa, 0xaa, 0x9f, 0x5e, 0x40, 0x01, 0xaa, 0xaa,
	0xaa, 0xaa, 0xa9, 0x7e, 0x40, 0x1a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
	0x9a, 0xaa, 0xaa, 0xaa
};

const uint8_t image_data_c4[256] = {
	0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa9, 0x7e,
	0xbd, 0x6a, 0xaa, 0xaa, 0xaa, 0xaa, 0x9f, 0x5e, 0xb5, 0xf6, 0xaa, 0xaa,
	0xaa, 0xa9, 0xd5, 0x5e, 0xb5, 0x57, 0x6a, 0xaa, 0xaa, 0xa7, 0x55, 0x5e,
	0xb5, 0x55, 0xda, 0xaa, 0xaa, 0x95, 0x55, 0x5e, 0xb5, 0x55, 0x56, 0xaa,
	0xaa, 0x55, 0x55, 0xd6, 0x97, 0x55, 0x55, 0xaa, 0xa9, 0xd5, 0x5d, 0xaa,
	0xaa, 0x75, 0x57, 0x6a, 0xaa, 0x7d, 0x7a, 0xaa, 0xaa, 0xad, 0x7d, 0xaa,
	0xa6, 0xa7, 0xea, 0xaa, 0xaa, 0xab, 0xda, 0x9a, 0xaf, 0x6a, 0xaa, 0xaa,
	0xaa, 0xaa, 0xa9, 0xfa, 0x9d, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x76,
	0x95, 0x5e, 0xaa, 0xaa, 0xaa, 0xaa, 0xb5, 0x56, 0xb5, 0x56, 0xaa, 0xaa,
	0xaa, 0xaa, 0x95, 0x5e, 0xb5, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x5e,
	0xb5, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x5e, 0xb5, 0x76, 0xaa, 0xaa,
	0xaa, 0xaa, 0x9d, 0x5e, 0xb5, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x5e,
	0xb5, 0x56, 0xaa, 0xaa, 0xaa, 0xaa, 0x95, 0x5e, 0x95, 0x5e, 0xaa, 0xaa,
	0xaa, 0xaa, 0xb5, 0x56, 0x9d, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x76,
	0xaf, 0x69, 0x6a, 0xaa, 0xaa, 0xaa, 0xa9, 0xfa, 0xa6, 0xa0, 0x1a, 0xaa,
	0xaa, 0xab, 0xda, 0x9a, 0xaa, 0xc0, 0x06, 0xaa, 0xaa, 0xad, 0x5d, 0xaa,
	0xa8, 0x00, 0x00, 0x6a, 0xaa, 0x75, 0x57, 0x6a, 0xaa, 0x00, 0x00, 0x02,
	0x97, 0x55, 0x55, 0xaa, 0xaa, 0x80, 0x00, 0x01, 0xb5, 0x55, 0x56, 0xaa,
	0xaa, 0xa0, 0x00, 0x01, 0xb5, 0x55, 0xda, 0xaa, 0xaa, 0xa8, 0x00, 0x01,
	0xb5, 0x57, 0x6a, 0xaa, 0xaa, 0xaa, 0x40, 0x01, 0xb5, 0xf6, 0xaa, 0xaa,
	0xaa, 0xaa, 0xa7, 0x01, 0xbd, 0x6a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa6,
	0xaa, 0xaa, 0xaa, 0xaa
};

const uint8_t image_data_c5[256] = {
	0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa9, 0x7e,
	0xbd, 0x6a, 0xaa, 0xaa, 0xaa, 0xaa, 0x9f, 0x5e, 0xb5, 0xf6, 0xaa, 0xaa,
	0xaa, 0xa9, 0xd5, 0x5e, 0xb5, 0x57, 0x6a, 0xaa, 0xaa, 0xa7, 0x55, 0x5e,
	0xb5, 0x55, 0xda, 0xaa, 0xaa, 0x95, 0x55, 0x5e, 0xb5, 0x55, 0x5e, 0xaa,
	0xaa, 0x55, 0x55, 0xd6, 0x97, 0xd5, 0x55, 0xaa, 0xa9, 0xd5, 0x5d, 0xaa,
	0xaa, 0x75, 0x57, 0x6a, 0xaa, 0x7d, 0x7a, 0xaa, 0xaa, 0xad, 0x5d, 0xaa,
	0xa3, 0xa7, 0xea, 0xaa, 0xaa, 0xab, 0xda, 0x5a, 0x90, 0x1a, 0xaa, 0xaa,
	0xaa, 0xaa, 0xa9, 0xfa, 0x80, 0x02, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x76,
	0x80, 0x01, 0xaa, 0xaa, 0xaa, 0xaa, 0xb5, 0x56, 0x80, 0x02, 0xaa, 0xaa,
	0xaa, 0xaa, 0x95, 0x5e, 0x40, 0x02, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x5e,
	0x40, 0x0e, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x5e, 0x40, 0x0e, 0xaa, 0xaa,
	0xaa, 0xaa, 0x9d, 0x5e, 0x40, 0x02, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x5e,
	0x80, 0x02, 0xaa, 0xaa, 0xaa, 0xaa, 0x95, 0x5e, 0x80, 0x01, 0xaa, 0xaa,
	0xaa, 0xaa, 0xb5, 0x56, 0xb0, 0x02, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x76,
	0x90, 0x1a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa9, 0xfa, 0xa1, 0xa7, 0xea, 0xaa,
	0xaa, 0xab, 0xda, 0x9a, 0xaa, 0x75, 0x7a, 0xaa, 0xaa, 0xad, 0x5d, 0xaa,
	0xa9, 0xd5, 0x5d, 0xaa, 0xaa, 0x75, 0x57, 0x6a, 0xaa, 0x55, 0x55, 0xd6,
	0x97, 0x55, 0x55, 0xaa, 0xaa, 0x95, 0x55, 0x5e, 0xb5, 0x55, 0x56, 0xaa,
	0xaa, 0xa7, 0x55, 0x5e, 0xb5, 0x55, 0xda, 0xaa, 0xaa, 0xa9, 0xd5, 0x5e,
	0xb5, 0x57, 0x6a, 0xaa, 0xaa, 0xaa, 0x9f, 0x5e, 0xb5, 0xf6, 0xaa, 0xaa,
	0xaa, 0xaa, 0xa9, 0x7e, 0xbd, 0x6a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
	0xaa, 0xaa, 0xaa, 0xaa
};

const uint8_t image_data_c6[256] = {
	0xaa, 0xaa, 0xaa, 0xa6, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4, 0x01,
	0xbd, 0x6a, 0xaa, 0xaa, 0xaa, 0xaa, 0x40, 0x01, 0xb5, 0xf6, 0xaa, 0xaa,
	0xaa, 0xa8, 0x00, 0x01, 0xb5, 0x57, 0x6a, 0xaa, 0xaa, 0xa0, 0x00, 0x01,
	0xb5, 0x55, 0xda, 0xaa, 0xaa, 0x80, 0x00, 0x01, 0xb5, 0x55, 0x5e, 0xaa,
	0xaa, 0x00, 0x00, 0x02, 0x97, 0x55, 0x55, 0xaa, 0xa8, 0x00, 0x00, 0x6a,
	0xaa, 0x75, 0x57, 0x6a, 0xaa, 0xc0, 0x06, 0xaa, 0xaa, 0xad, 0x5d, 0xaa,
	0xa5, 0xa0, 0x1a, 0xaa, 0xaa, 0xab, 0xda, 0x9a, 0xaf, 0x69, 0x6a, 0xaa,
	0xaa, 0xaa, 0xa9, 0xfa, 0x95, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x76,
	0x95, 0x5e, 0xaa, 0xaa, 0xaa, 0xaa, 0xb5, 0x56, 0xb5, 0x56, 0xaa, 0xaa,
	0xaa, 0xaa, 0x95, 0x5e, 0xb5, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x5e,
	0xb5, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x5e, 0xb5, 0x76, 0xaa, 0xaa,
	0xaa, 0xaa, 0x9d, 0x5e, 0xb5, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x5e,
	0xb5, 0x56, 0xaa, 0xaa, 0xaa, 0xaa, 0x95, 0x5e, 0x95, 0x5e, 0xaa, 0xaa,
	0xaa, 0xaa, 0xb5, 0x56, 0x9d, 0x76, 0xaa, 0xaa, 0xaa, 0xaa, 0x9d, 0x76,
	0xaf, 0x6a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa9, 0xfa, 0xa5, 0xa7, 0xea, 0xaa,
	0xaa, 0xab, 0xda, 0x5a, 0xaa, 0x75, 0x7a, 0xaa, 0xaa, 0xad, 0x5d, 0xaa,
	0xa9, 0xd5, 0x5d, 0xaa, 0xaa, 0x75, 0x57, 0x6a, 0xaa, 0x55, 0x55, 0xd6,
	0x97, 0x55, 0x55, 0xaa, 0xaa, 0x95, 0x55, 0x5e, 0xb5, 0x55, 0x56, 0xaa,
	0xaa, 0xa7, 0x55, 0x5e, 0xb5, 0x55, 0xda, 0xaa, 0xaa, 0xa9, 0xd5, 0x5e,
	0xb5, 0x57, 0x6a, 0xaa, 0xaa, 0xaa, 0x9f, 0x5e, 0xb5, 0xf6, 0xaa, 0xaa,
	0xaa, 0xaa, 0xa9, 0x7e, 0xbd, 0x6a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
	0xaa, 0xaa, 0xaa, 0xaa
};

int main(void)
{
    Set48MHzClk();
    delay_init();

	LCD_Interface_Init();                //Inicjalizacja inerfejsu czcego z LCD
	//LCD_Init65k();
	LCD_Init256();                       //Inicjalizacja LCD
	
	RA_SendCmdWithData(RA_Memory_Write_Control_Register1, (RS8875_MWCR1_Reg){.GrCursorEn=false, .CursorType=0, .Memory=RA_DestWriteLayer12, .Layer=0}.byte);
	LCD_Rect(0, 0, LCD_GetMaxX(), LCD_GetMaxY(), 0x0000); //Wyczy pierwszy ekran
	RA_SendCmdWithData(RA_Memory_Write_Control_Register1, (RS8875_MWCR1_Reg){.GrCursorEn=false, .CursorType=0, .Memory=RA_DestWriteLayer12, .Layer=1}.byte);
	LCD_Rect(0, 0, LCD_GetMaxX(), LCD_GetMaxY(), 0x0000); //Wyczy drugi ekran

	RA_SendCmdWithData(RA_Memory_Write_Control_Register0, (RS8875_MWCR0_Reg){.NoReadAutoIncr=0, .NoWriteAutoIncr=0, .Direction=RA_MWLeftRightTopDown}.byte);
	RA_SendCmdWithData(RA_Memory_Read_Cursor_Direction, (RS8875_MRCD_Reg){.Direction=RA_MWLeftRightTopDown}.byte);
	
	
	for(uint8_t y=0; y<4; y++)
	for(uint8_t x=0; x<4; x++)
	RA_DrawBitmap332(x*200, y*120, image_data_blues, 0);  //Narysuj kafelki na warstwie 1

	RA_SetCurShape(0, image_data_c1);
	RA_SetCurShape(1, image_data_c2);
	RA_SetCurShape(2, image_data_c3);
	RA_SetCurShape(3, image_data_c4);
	RA_SetCurShape(4, image_data_c5);
	RA_SetCurShape(5, image_data_c6);
	
	RA_SetGraphCursorColor(0x1C, 0x04);
	RA_SetGraphCursorPos(400, 240);

	uint8_t n=0;

	while(1)
	{
		RA_GraphCursorEn(true, n);
		n=(n+1) % 6;
		delay_ms(100);
	}
}
