/*
 * RingBuffer.h
 *
 * Created: 2013-01-22 23:10:31
 *  Author: tmf
 */ 


#ifndef RINGBUFFER_H_
#define RINGBUFFER_H_

#include <stdint.h>
#include <stdbool.h>
#include "FT5x06.h"

#define CB_MAXTRANS  40         //Maksymalna liczba elementw bufora

typedef FT_TouchPoint_Reg CB_Element;     //Typ elementw w buforze

typedef struct
{
	uint8_t Beg;                       //Pierwszy element bufora
	volatile uint8_t Count;            //Liczba elementw w buforze
	CB_Element elements[CB_MAXTRANS];  //Elementy bufora
} CircBuffer;

_Bool cb_Add(CircBuffer *cb, CB_Element elem);		//Dodaj element do kolejki, jeli true to ok, jeli false to nie udao si doda elementu (kolejka pena)
_Bool cb_Read(CircBuffer *cb, CB_Element *elem);	//Pobierz element z kolejki, jeli true to ok, jeli false to nie ma elementu

static inline _Bool cb_IsFull(CircBuffer *cb)
{
	return cb->Count == CB_MAXTRANS;
}

static inline _Bool cb_IsEmpty(CircBuffer *cb)
{
	return cb->Count == 0;
}

#endif /* RINGBUFFER_H_ */