/*
 * FT5x06.h
 *
 * Created: 2016-01-24 13:38:56
 *  Author: tmf
 */ 


#ifndef FT5X06_H_
#define FT5X06_H_

#include <stdint.h>

#define FT5206_Address		0x70		//Adres I2C ukadu

//Rejestry ukadu
#define FT_5x06_DEVICE_MODE		0x00
#define FT_5x06_GEST_ID			0x01
#define FT_5x06_TD_STATUS		0x02
#define FT_5x06_TOUCH_XH		0x03	//Kolejne 4 rejestry powtarzach si piciokrotnie dla kolejnych punktw dotyku
#define FT_5x06_TOUCH_XL		0x04
#define FT_5x06_TOUCH_YH		0x05
#define FT_5x06_TOUCH_YL		0x06
#define FT_5x06_ID_G_THGROUP	0x80	//Prg detekcji dotyku
#define FT_5x06_ID_G_THPEAK		0x81	//Prg detekcji szczytu dotyku
#define FT_5x06_ID_G_THCAL		0x82	//Prg dla wyliczenia centralnego punktu dotyku
#define FT_5x06_ID_G_THWATER	0x83	//Prg jeli powierzchni jest woda
#define FT_5x06_ID_G_THTEMP		0x84	//Kompensacja temperatury
#define FT_5x06_ID_G_CTRL		0x86	//Kontrola zasilania
#define FT_5x06_ID_G_TIME_ENTER_MONITOR	0x87
#define FT_5x06_ID_G_PERIODACTIVE	0x88
#define FT_5x06_ID_G_PERIODMONITOR	0x89
#define FT_5x06_ID_G_LIB_VERSION_H	0xA1
#define FT_5x06_ID_G_LIB_VERSION_L	0xA2
#define FT_5x06_ID_G_CIPHER		0xA3
#define FT_5x06_ID_G_MODE		0xA4
#define FT_5x06_ID_G_PMODE		0xA5
#define FT_5x06_ID_G_FIRMID		0xA6
#define FT_5x06_ID_G_STATE		0xA7
#define FT_5x06_ID_G_TFID		0xA8
#define FT_5x06_ID_G_ERR		0xA9
#define FT_5x06_ID_G_CLB		0xAA
#define FT_5x06_ID_G_B_AREAT_TH	0xAE

#define FT_5x06_InterruptEnable		0x00		//Odblokuj lini INT
#define FT_5x06_InterruptDisable	0x01		//Zablokuj lini INT

//Typy rozpoznawanych gestw
typedef enum {FT_MoveUp=0x10, FT_MoveLeft=0x14, FT_MoveDown=0x18, FT_MoveRight=0x1C, FT_ZoomIn=0x48, FT_ZoomOut=0x49, FT_NoGesture=0x00} FT5x06_GEST;

typedef union
{
	struct
	{
		uint8_t TouchPointsNo     : 4;		//Liczba nacinitych punktw (1-5)
	};
	uint8_t byte;
} FT_Status_Reg;

typedef enum {FT_PutDown, FT_PutUp, FT_Contact, FT_Reserved} FT5x06_Touch;

typedef union
{
	struct
	{
		uint8_t XPOS_MSB     : 4;		//Bity 11:8 pozycji X
		uint8_t Reserved	 : 2;
		FT5x06_Touch Type	 : 2;		//Co si stao?
		uint8_t XPOS_LSB	 : 8;
		uint8_t YPOS_MSB	 : 4;
		uint8_t TouchID		 : 4;
		uint8_t YPOS_LSB	 : 8;
		uint16_t dummy;					//Pomidzy kolejnymi punktami s dwa niewykorzystane bajty
	};
	uint8_t byte;
} FT_TouchPoint_Reg;

void CTP_Init();			//Inicjalizacja interfejsu CTP

_Bool CTP_ReadRegister(uint8_t reg, uint8_t *value, uint8_t bytesno);  //Odczytaj bytesno bajtw poczwszy od rejestru o podanym numerze. Zwraca false jeli co jest nie tak
_Bool CTP_WriteRegister(uint8_t reg, uint8_t *value, uint8_t bytesno); //j.w. tylko zapisuje

#endif /* FT5X06_H_ */