/**
* Ten program odczytuje stan przycisku i zmienia wartosc na diodzie LED po jego nacisnieciu.
* Debouncing przycisku polega na odczekaniu okreslonej liczby milisekund.
* Autor: Miguel Garcia-Ruiz
* Wersja: 1.0
* 19 pazdziernika 2020
*/
#include <xc.h>
#include <stdio.h>
#include "mcc_generated_files/mcc.h"

int odczyt_przycisku=0;
//unsigned int millis;
void main(void)
{
    // inicjalizacja plytki mikrokontrolera:
    SYSTEM_Initialize();
    IO_RD2_SetDigitalOutput(); //ustawienie portu RD2 jako wyjscia.
    IO_RA0_SetDigitalInput(); //ustawienie portu RA0 jako wejscia.
    IO_RA0_SetPullup(); //aktywacja wewnetrzego rezystora podciagajacego
    IO_RD2_SetLow(); //inicjalizacja portu wyjsciowego niskim stanem logicznym (LOW)
    while (1) //petla nieskonczona
    {
        odczyt_przycisku=IO_RA0_GetValue(); //odczyt portu RA0
        __delay_ms(100); //odczekaj 100 milliseconds, zeby sprawdzic, czy przycisk jest nadal wcisniety.
                         // zmien stan w zaleznosci od stanu przycisku.
        odczyt_przycisku=IO_RA0_GetValue();
        //ok, przycisk jest nadal wcisniety po 100 milisekundach.
        if (odczyt_przycisku==LOW){
        IO_RD2_Toggle(); // odwroc aktualny stan portu wyjsciowego
        }
    }
}
/**
 Koniec pliku 
*/
