/**
  Kreatywny projekt mikrokontrolerowy DIY w języku C, opublikowany przez Packt
  Rozdzial 7.: Przelacznik akustyczny: wykrywanie prostym mikrofonem dwoch klasniec z rzedu.
  Cwiczenie 3.: Dioda zaswieci sie po wykryciu dwoch klasniec przez mikrofon w określonych ramach czasowych.
  Wersja: 1
  Sierpien 2020
  Modyfikacja: Marcin Machnik, styczen 2022 (dodany reset licznikow, gdy czas miedzy klasnieciami jest wiekszy niz 3000 milisekund)
*/

const int MicPinAnalogowy = 0;                   // analogowy pin wejściowy
const int LedPinCyfrowy = PC13;               // cyfrowy pin wyjściowy
const int ProgKlasniecia = 300;                // minimalna wykrywana glosnosc
int LiczbaKlasniec = 0;                       // licznik klasniec
bool StanLed = false;                         // stan diody LED

unsigned long PierwszeKlasniecie = 0;         // czas pierwszego klasniecia
unsigned long DrugieKlasniecie = 0;           // czas drugiego klasniecia

void setup() {
  Serial.begin(9600);                         // inicjuje transmisje szeregowa
  pinMode(LedPinCyfrowy, OUTPUT);             // ustawia pin cyfrowy jako wyjscie
  pinMode(MicPinAnalogowy, INPUT);               // ustawia pin analogowy jako wejscie
}

void loop() {
  int SilaDzwieku = analogRead(MicPinAnalogowy);  // odczytuje dane z pinu analogowego
  if (SilaDzwieku > ProgKlasniecia) {           // wykryto klasniecie?
   LiczbaKlasniec++;                            // zwieksz liczbe klasniec o 1
   delay(500);                                  // 500 milisekund przerwy
   PierwszeKlasniecie = (LiczbaKlasniec == 1) ? millis() : PierwszeKlasniecie; // zapisz czas pierwszego klasniecia
  }
  if (LiczbaKlasniec == 2) {                    // drugie klasniecie?
    DrugieKlasniecie = millis();                // zapisz czas drugiego klasniecia
    if (DrugieKlasniecie - PierwszeKlasniecie < 30000) {  // sprawdz odstep miedzy klasnieciami
      if (StanLed) {                               // sprawdz stan diody LED (ON czy OFF)
        digitalWrite (LedPinCyfrowy, HIGH);         // zapal diode LED
      } else {
        digitalWrite (LedPinCyfrowy, LOW);          // zgas diode LED
      }
      LiczbaKlasniec = 0;                          // wyzeruj licznik klasniec
      StanLed = !StanLed;                          // zmien stan LED na przeciwny
      PierwszeKlasniecie = 0;                      // wyzeruj czas klasniec
      DrugieKlasniecie = 0;
    } else {
      LiczbaKlasniec = 0;                         // wyzeruj liczniki, gdy czas miedzy klasnieciami jest wiekszy niz 30 sekund
      PierwszeKlasniecie = 0;
      DrugieKlasniecie = 0;
    }  
  }
}
