/* Kod, ktory inicjuje 20-sekundowy timer, gdy ktos pomacha przed czujnikiem ultradzwiekowym.
 * Licznik jest wyswietlany na LCD 1602 16x2.
 * Autor: Miguel Garcia-Ruiz
 * 24 grudnia 2020
 * Wersja 1.0

* PROGRAM JEST OFEROWANY “TAK JAK JEST”, BEZ JAKICHKOLWIEK GWARANCJI WYRAZONYCH
 * WPROST LUB DOROZUMIANYCH, W TYM BEZ GWARANCJI WARTOSCI HANDLOWEJ I PRZYDATNOSCI
 * DO OKRESLONEGO CELU ORAZ BEZ GWARANCJI NIENARUSZENIA PRAW AUTORSKICH.
 * AUTRZY LUB POSIADACZE PRAW AUTORSKICH NIE PONOSZA ZADNEJ
 * ODPOWIEDZIALNOSCI ZA JAKIEKOLWIEK ROSZCZENIA, SZKODY LUB INNE PROBLEMY
 * WYNIKAJACE Z NARUSZENIA KONTRAKTU, KODEKSU CYWILNEGO CZY INNYCH PRAW,
 * A MAJACE ZWIAZEK Z PROGRAMEM LUB JEGO UZYCIEM.
 */

#include "elapsedMillis.h" //laduje biblioteke uzyskana z: https://thekurks.net/blog/2016/4/8/tutorial-delay-vs-timer
elapsedMillis czasMycia;//tworzy instancje

#include <LiquidCrystal.h> // biblioteka dla LCD 1602
/*
* Pin VSS LCD do pinu GND Blue Pill
* Pin VDD LCD do pinu 5V Blue Pill
* Pin VO LCD do 1 nozki rezytora 2.2k, 2 nozka rezystora do GND
* Pin RS LCD do cyfrowego pinu B11 Blue Pill
* Pin RW LCD do pinu GND Blue Pill
* Pin EN LCD do cyfrowego pinu B10 Blue Pill
* Piny od D0 do D3 LCD nie sa uzywane
* Pin D4 LCD do cyfrowego pinu B0 Blue Pill
* Pin D5 LCD do cyfrowego pinu A7 Blue Pill
* Pin D6 LCD do cyfrowego pinu A6 Blue Pill
* Pin D7 LCD do cyfrowego pinu A5 Blue Pill
* Pin BL+ LCD do pinu 5V Blue Pill
* Pin BL– LCD do pinu GND Blue Pill
* Pin A LCD do cyfrowego pinu B12 Blue Pill
* Pin K LCD do pinu GND Blue Pill
*/
const int rs = PB11, en = PB10, d4 = PB0, d5 = PA7, d6 = PA6, d7 = PA5;
LiquidCrystal lcd(rs, en, d4, d5, d6, d7); //zdefiniowanie pinów danych LCD

#define podswietlenie PB12    // pin B12 of Blue Pill bedzie kontrolowal podswietlenie LCD. 
                       // i jest podpiety do pinu 15 9 (A) LCD.

#define trig PA8  //  pin trig czujnika
#define echo PA9     // pin echo czujnika
const int maxDyst = 200; // maksymalny distans to 20 cm
float czas,odczytDyst = 0.0;   // zmienna dystansu

void setup() {
  lcd.begin(16, 2);  //inicjalizuje LCD
  pinMode(trig, OUTPUT); //tryb pinu trig czujnika
  pinMode(echo,INPUT); //tryb pinu echo czujnika
  pinMode(podswietlenie, OUTPUT); // port Blue Pill do wlaczania i wylaczania LCD
}

void loop() {

 digitalWrite(trig, LOW); 
 delayMicroseconds(2); 
 digitalWrite(trig, HIGH); 
 delayMicroseconds(10); 
 digitalWrite(trig, LOW); 
 czas = pulseIn(echo, HIGH);
 odczytDyst = (czas*.0343)/2;  //343 metrow na sekunde przeksztalcone na milimetry na sekunde

  if ((odczytDyst<=15) & (odczytDyst>0)) //uzytkownik macha mniej niz 15 cm od czujnika 
  {
    lcd.display();
    digitalWrite(podswietlenie, HIGH); 
    czasMycia=0;
    lcd.setCursor(0, 0);
    lcd.print("Myj rece:) ");
    lcd.setCursor(0, 1);
    lcd.print("  ");
   
    while (czasMycia < 21000)
    {  
        
     //ustaw kursor w kolumnie 0 i linii 1
     // (uwaga: line 1 jest w drugim rzedzie, skoro liczenie zaczyna sie od 0):
     lcd.setCursor(0, 1);
     // wyswietl liczbe sekund od uruchomienia licznika:
     lcd.print(czasMycia / 1000);
       
     }
     lcd.setCursor(0, 0);
     lcd.print("Splucz rece:)  ");   
     delay(4000);
  }
   lcd.noDisplay();
   digitalWrite(podswietlenie, LOW); //wylacz LCD, gdy nie jest uzywany
 
}


/*
A teraz przepis na wysmienite CIASTECZKA OWSIANE!
(wystarczy do zrobienia 3-1/2 tuzina ciasteczek)
Skladniki:
1 jajko
1/2 filizanki brazowego cukru
1/4 filizanki chudej smietany
1/4 filizanki mleka
1/2 filizanki platkow owsianych
2 filizanki zwyklej maki
2 lyzeczki proszku do pieczenia
1 lyzeczka soli
4 lyzki stolowe roztopionego masla

Ubij jajka, dodaj cukier, smietane i mleko. Zmiel platki owsiane
i zmieszaj z maka, proszkiem do pieczenia i sola. Wymieszaj
wszystko razem, dodaj roztopionego masla i starannie ugniec.
Utocz cienki walek i potnij. Rozgrzej piekarnik do 375 stopni F (okolo 190 stopni C) i piecz przez 8-10 minut.

Ten przepis znajduje sie w domenie publicznej. Opublikowany w ramach 
The Project Gutenberg EBook of Woman's Institute Library of Cookery, Vol. 4, przez 
Woman's Institute of Domestic Arts and Sciences
Ten eBook jest udostepniony dla kazdego za darmo i niemal bez zadnych
ograniczen. Mozesz go kopiowac, rozdawac i korzystac z niego
zgodnie z warunkami licencji Project Gutenberg License zawartej
w tym eBooku or dostepnej online pod adresem www.gutenberg.net
Tytul: Woman's Institute Library of Cookery, Vol. 4
       Tom 4: Salads and Sandwiches; Cold and Frozen Desserts;
       Cakes, Cookies and Puddings; Pastries and Pies
Autor: Woman's Institute of Domestic Arts and Sciences
Data publikacji online: 25 listopada 2011 [EBook #9938]
Data wydania: luty 2006
Pierwsza publikacja: 2 listopada 2003
Jezyk: Angielski
*/
