/**
Ten program zapala diode na sekunde (1000 milisekund).
 * Wbudowana zolta dioda bedzie migac. Jesli podepniesz diode LED z rezystorem 220 ohm 
 * do pinu RE0, ona takze bedzie migac. Port (pin) RE0 jest wewnetrznie polaczony z wbudowana dioda. 
 * Autor: Miguel Garcia-Ruiz
 * Wersja 1.
 * Lipiec 2020
*/

#include "mcc_generated_files/mcc.h" //generowana przez MCC niezbedna biblioteka, ktora 
                                     //definiuje porty I/O (piny).

void main(void) //glowna funkcja programu
{
    // inicjalizacja mikrokontrolera:
    SYSTEM_Initialize(); //inicjalizaja portow plytki
    LED0_SetDigitalOutput(); //ustawienie pinu LED0 jako wyjscia (ktory jest juz zdefiniowany w bibliotece mcc.h)

    while (1) //petla nieskonczona
    {
        LED0_SetLow(); //wylaczenie wbudowanej diody i pinu RE0 
        __delay_ms(1000); //zatrzymanie programu na 1 sekunde (1000 milisekund)
        LED0_SetHigh(); //wlaczenie wbudowanej diody i pinu RE0
        __delay_ms(1000); // zatrzymanie programu na 1 sekunde (1000 milisekund)
    }
}
/**
 Koniec pliku 
*/