/*
 Ten program odczytuje fotorezystor podlaczony do analogowego portu i analizuje czy
 * czy ilosc swiatla jest dobra, slaba, czy zbyt niska, a nastepnie wlacza
 * zielona, zolta lub czerwona diode LED.
 * Autor: Miguel Garcia-Ruiz
 * 6 listopad 2020
 * Wersja 1.
 */
#include <xc.h>
#include <stdio.h>
#include "mcc_generated_files/mcc.h"

static uint16_t odczyt_fotorezystora=0;
/*odczyt_fotorezystora to zmienna, ktora przechowuje wynik konwersji analogowo
 * cyfrowej (ADC) wykonywanej przez funkcje ADC_GetConversion().
static to taki rodzaj deklaracji zmiennej, w ktorym przechowywana wartosc
obowiazuje w calym kodzie. Domyslna wartosc zmiennej typu static to 0.
uint16_t pozwala zadeklarowac zmienna jako 16-bitowa liczbe calkowita,
co oznacza, ze moze przyjmowac wartosc do 65535.
*/
void main(void)
{

    SYSTEM_Initialize(); //Inicjalizuje urzadzenie
    ADC_Initialize(); //Inicjalizuje konwersje analogowo cyfrowa (ADC)
    while (1) // petla nieskonczona
    {
        IO_RD1_SetLow(); //Ustawia na porcie logiczny stan niski (LOW)
        IO_RD2_SetLow(); //Ustawia na porcie logiczny stan niski (LOW)
        IO_RD3_SetLow(); //Ustawia na porcie logiczny stan niski (LOW)
        odczyt_fotorezystora=ADC_GetConversion(channel_ANA0); //odczytuje port RA0
//i nastepuje analiza progowych wartosci wynikow ADC: 
        if (odczyt_fotorezystora>=0 && odczyt_fotorezystora <=128)
        {
            IO_RD1_SetHigh(); // za ciemno
        } else if (odczyt_fotorezystora>= 129 && odczyt_fotorezystora<=512)
        {
            IO_RD2_SetHigh(); // polmrok
        } else
        {
            IO_RD3_SetHigh(); // normalne swiatlo
        }
        __delay_ms(200); // pozwala fotorezystorowi odczytac ilosc swiatla
    }
}
/**
 Koniec pliku
*/
