/*
 Program do odczytywania temperatury w stopniach Celsjusza z czujnika LM35.
 * Program zapala zielona diode LED, gdy temperatura jest w strefie komfortu termicznego (od 23 do 26 stopni Celsjusza)
 * zgodnie z https://www.ccohs.ca/oshanswers/phys_agents/thermal_comfort.html
 * Autor: Miguel Garcia-Ruiz
 * Wersja 1
 * 21 listopada 2020
 */

#include "mcc_generated_files/mcc.h"

static uint16_t odczytLM35=0; // zdefiniowanie zmiennej typu integer unsigned short
float temp=0.0; //zmienna do przechowywania wartosci przekonwertowanej na stopnie Celsjusza

void main(void)
{
    
    SYSTEM_Initialize(); // inicjalizuje urzadzenie
    ADC_Initialize(); // initialize konwersje analogowo-cyfrowa (ADC))
    while (1)  //petla nieskonczona
    {
       IO_RD2_SetLow();
       IO_RD3_SetLow();
       odczytLM35=ADC_GetConversion(channel_ANA0); // wykonaj konwersje ADC
       temp=(5.0/1023)*odczytLM35;
       if (temp>=23.0 && temp<=26.0) //strefa komfortu termicznego
       {
         IO_RD3_SetHigh(); //zapala zielona diode LED
       } else {
         IO_RD2_SetHigh(); //zapala zolta diode LED, temperatura poza strefa komfortu
       }    
       __delay_ms(500); //odczekuje chwile przed ponownym odczytaniem wartosci z LM35
    }
}
/**
 Koniec pliku
*/