<h1 align="center">
Mathematics of Machine Learning</h1>
<p align="center">This is the code repository for <a href ="https://www.packtpub.com/en-us/product/mathematics-of-machine-learning-9781837027866"> Mathematics of Machine Learning</a>, published by Packt.
</p>

<h2 align="center">
Master linear algebra, calculus, and probability for machine learning
</h2>
<p align="center">
Tivadar Danka</p>

<p align="center">
   <a href="https://packt.link/math" alt="Discord" title="Learn more on the Discord server"><img width="32px" src="https://cliply.co/wp-content/uploads/2021/08/372108630_DISCORD_LOGO_400.gif"/></a>
  &#8287;&#8287;&#8287;&#8287;&#8287;
<!--   <a href="https://packt.link/free-ebook/9781837027873"><img width="32px" alt="Free PDF" title="Free PDF" src="https://cdn-icons-png.flaticon.com/512/4726/4726010.png"/></a> -->
<!--  &#8287;&#8287;&#8287;&#8287;&#8287; -->
  <a href="https://packt.link/gbp/9781837027873"><img width="32px" alt="Graphic Bundle" title="Graphic Bundle" src="https://cdn-icons-png.flaticon.com/512/2659/2659360.png"/></a>
  &#8287;&#8287;&#8287;&#8287;&#8287;
   <a href="https://www.amazon.com/Mathematics-Machine-Learning-Calculus-Probability/dp/1837027870/"><img width="32px" alt="Amazon" title="Get your copy" src="https://cdn-icons-png.flaticon.com/512/15466/15466027.png"/></a>
  &#8287;&#8287;&#8287;&#8287;&#8287;
</p>
<details open> 
  <summary><h2>About the book</summary>
<a href="https://www.packtpub.com/en-us/product/mathematics-of-machine-learning-9781837027866">
<img src="https://content.packt.com/B32104/cover_image_small.jpg" alt="" height="256px" align="right">
</a>

Mathematics of Machine Learning provides a rigorous yet accessible introduction to the mathematical underpinnings of machine learning, designed for engineers, developers, and data scientists ready to elevate their technical expertise. With this book, you’ll explore the core disciplines of linear algebra, calculus, and probability theory essential for mastering advanced machine learning concepts. 

PhD mathematician turned ML engineer Tivadar Danka—known for his intuitive teaching style that has attracted 100k+ followers—guides you through complex concepts with clarity, providing the structured guidance you need to deepen your theoretical knowledge and enhance your ability to solve complex machine learning problems. Balancing theory with application, this book offers clear explanations of mathematical constructs and their direct relevance to machine learning tasks. Through practical Python examples, you’ll learn to implement and use these ideas in real-world scenarios, such as training machine learning models with gradient descent or working with vectors, matrices, and tensors. 

 By the end of this book, you’ll have gained the confidence to engage with advanced machine learning literature and tailor algorithms to meet specific project requirements. 
</details>
<details open> 
  <summary><h2>Key Learnings</summary>
<ul>

<li>Understand core concepts of linear algebra, including matrices, eigenvalues, and decompositions</li>

<li>Grasp fundamental principles of calculus, including differentiation and integration</li>

<li>Explore advanced topics in multivariable calculus for optimization in high dimensions</li>

<li>Master essential probability concepts like distributions, Bayes' theorem, and entropy</li>

<li>Bring mathematical ideas to life through Python-based implementations</li>

</ul>

  </details>

<details open> 
  <summary><h2>Chapters</summary>


| Chapters | Colab | Kaggle | Gradient | Studio Lab |
| :-------- | :-------- | :------- | :-------- | :-------- |
| **Part 1: Linear Algebra** | | | | |
| <ul><li>Chapter 1, Vectors and Vector Spaces</li></ul> | <a href="https://colab.research.google.com/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-01-linear-algebra/01-vectors-and-vector-spaces.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"></a><br> | <a href="https://www.kaggle.com/kernels/welcome?src=https://github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-01-linear-algebra/01-vectors-and-vector-spaces.ipynb"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Open In Kaggle"></a><br> | <a href="https://gradient.run/notebook/github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-01-linear-algebra/01-vectors-and-vector-spaces.ipynb"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Open In Gradient"></a><br> | <a href="https://studiolab.sagemaker.aws/import/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-01-linear-algebra/01-vectors-and-vector-spaces.ipynb"><img src="https://studiolab.sagemaker.aws/studiolab.svg" alt="Open In Studio Lab"></a><br> |
| <ul><li>Chapter 2, The Geometric Structure of Vector Spaces</li></ul> | <a href="https://colab.research.google.com/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-01-linear-algebra/02-the-geometric-structure-of-vector-spaces.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"></a><br> | <a href="https://www.kaggle.com/kernels/welcome?src=https://github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-01-linear-algebra/02-the-geometric-structure-of-vector-spaces.ipynb"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Open In Kaggle"></a><br> | <a href="https://gradient.run/notebook/github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-01-linear-algebra/02-the-geometric-structure-of-vector-spaces.ipynb"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Open In Gradient"></a><br> | <a href="https://studiolab.sagemaker.aws/import/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-01-linear-algebra/02-the-geometric-structure-of-vector-spaces.ipynb"><img src="https://studiolab.sagemaker.aws/studiolab.svg" alt="Open In Studio Lab"></a><br> |
| <ul><li>Chapter 3, Linear Algebra in Practice</li></ul> | <a href="https://colab.research.google.com/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-01-linear-algebra/03-linear-algebra-in-practice.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"></a><br> | <a href="https://www.kaggle.com/kernels/welcome?src=https://github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-01-linear-algebra/03-linear-algebra-in-practice.ipynb"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Open In Kaggle"></a><br> | <a href="https://gradient.run/notebook/github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-01-linear-algebra/03-linear-algebra-in-practice.ipynb"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Open In Gradient"></a><br> | <a href="https://studiolab.sagemaker.aws/import/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-01-linear-algebra/03-linear-algebra-in-practice.ipynb"><img src="https://studiolab.sagemaker.aws/studiolab.svg" alt="Open In Studio Lab"></a><br> |
| <ul><li>Chapter 5, Matrices and Equations</li></ul> | <a href="https://colab.research.google.com/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-01-linear-algebra/05-matrices-and-equations.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"></a><br> | <a href="https://www.kaggle.com/kernels/welcome?src=https://github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-01-linear-algebra/05-matrices-and-equations.ipynb"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Open In Kaggle"></a><br> | <a href="https://gradient.run/notebook/github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-01-linear-algebra/05-matrices-and-equations.ipynb"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Open In Gradient"></a><br> | <a href="https://studiolab.sagemaker.aws/import/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-01-linear-algebra/05-matrices-and-equations.ipynb"><img src="https://studiolab.sagemaker.aws/studiolab.svg" alt="Open In Studio Lab"></a><br> |
| <ul><li>Chapter 7, Matrix Factorizations</li></ul> | <a href="https://colab.research.google.com/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-01-linear-algebra/07-matrix-factorizations.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"></a><br> | <a href="https://www.kaggle.com/kernels/welcome?src=https://github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-01-linear-algebra/07-matrix-factorizations.ipynb"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Open In Kaggle"></a><br> | <a href="https://gradient.run/notebook/github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-01-linear-algebra/07-matrix-factorizations.ipynb"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Open In Gradient"></a><br> | <a href="https://studiolab.sagemaker.aws/import/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-01-linear-algebra/07-matrix-factorizations.ipynb"><img src="https://studiolab.sagemaker.aws/studiolab.svg" alt="Open In Studio Lab"></a><br> |
| **Part 2: Calculus** | | | | |
| <ul><li>Chapter 9, Functions</li></ul> | <a href="https://colab.research.google.com/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-02-functions/01-functions.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"></a><br> | <a href="https://www.kaggle.com/kernels/welcome?src=https://github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-02-functions/01-functions.ipynb"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Open In Kaggle"></a><br> | <a href="https://gradient.run/notebook/github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-02-functions/01-functions.ipynb"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Open In Gradient"></a><br> | <a href="https://studiolab.sagemaker.aws/import/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-02-functions/01-functions.ipynb"><img src="https://studiolab.sagemaker.aws/studiolab.svg" alt="Open In Studio Lab"></a><br> |
| <ul><li>Chapter 10, Numbers, Sequences, and Series</li></ul> | <a href="https://colab.research.google.com/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-02-functions/02-numbers-sequences-series.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"></a><br> | <a href="https://www.kaggle.com/kernels/welcome?src=https://github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-02-functions/02-numbers-sequences-series.ipynb"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Open In Kaggle"></a><br> | <a href="https://gradient.run/notebook/github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-02-functions/02-numbers-sequences-series.ipynb"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Open In Gradient"></a><br> | <a href="https://studiolab.sagemaker.aws/import/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-02-functions/02-numbers-sequences-series.ipynb"><img src="https://studiolab.sagemaker.aws/studiolab.svg" alt="Open In Studio Lab"></a><br> |
| <ul><li>Chapter 12, Differentiation</li></ul> | <a href="https://colab.research.google.com/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-02-functions/04-differentiation.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"></a><br> | <a href="https://www.kaggle.com/kernels/welcome?src=https://github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-02-functions/04-differentiation.ipynb"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Open In Kaggle"></a><br> | <a href="https://gradient.run/notebook/github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-02-functions/04-differentiation.ipynb"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Open In Gradient"></a><br> | <a href="https://studiolab.sagemaker.aws/import/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-02-functions/04-differentiation.ipynb"><img src="https://studiolab.sagemaker.aws/studiolab.svg" alt="Open In Studio Lab"></a><br> |
| <ul><li>Chapter 13, Optimization</li></ul> | <a href="https://colab.research.google.com/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-02-functions/05-optimization.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"></a><br> | <a href="https://www.kaggle.com/kernels/welcome?src=https://github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-02-functions/05-optimization.ipynb"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Open In Kaggle"></a><br> | <a href="https://gradient.run/notebook/github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-02-functions/05-optimization.ipynb"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Open In Gradient"></a><br> | <a href="https://studiolab.sagemaker.aws/import/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-02-functions/05-optimization.ipynb"><img src="https://studiolab.sagemaker.aws/studiolab.svg" alt="Open In Studio Lab"></a><br> |
| <ul><li>Chapter 14, Integration</li></ul> | <a href="https://colab.research.google.com/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-02-functions/06-integration.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"></a><br> | <a href="https://www.kaggle.com/kernels/welcome?src=https://github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-02-functions/06-integration.ipynb"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Open In Kaggle"></a><br> | <a href="https://gradient.run/notebook/github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-02-functions/06-integration.ipynb"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Open In Gradient"></a><br> | <a href="https://studiolab.sagemaker.aws/import/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-02-functions/06-integration.ipynb"><img src="https://studiolab.sagemaker.aws/studiolab.svg" alt="Open In Studio Lab"></a><br> |
| **Part 3: Multivariable Calculus** | | | | |
| <ul><li>Chapter 17, Optimization in Multiple Variables</li></ul> | <a href="https://colab.research.google.com/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-03-multivariable-functions/03-optimization-in-multiple-variables.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"></a><br> | <a href="https://www.kaggle.com/kernels/welcome?src=https://github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-03-multivariable-functions/03-optimization-in-multiple-variables.ipynb"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Open In Kaggle"></a><br> | <a href="https://gradient.run/notebook/github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-03-multivariable-functions/03-optimization-in-multiple-variables.ipynb"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Open In Gradient"></a><br> | <a href="https://studiolab.sagemaker.aws/import/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-03-multivariable-functions/03-optimization-in-multiple-variables.ipynb"><img src="https://studiolab.sagemaker.aws/studiolab.svg" alt="Open In Studio Lab"></a><br> |
| **Part 4: Probability Theory** | | | | |
| <ul><li>Chapter 18, What is Probability</li></ul> | <a href="https://colab.research.google.com/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-04-probability-theory/01-what-is-probability.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"></a><br> | <a href="https://www.kaggle.com/kernels/welcome?src=https://github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-04-probability-theory/01-what-is-probability.ipynb"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Open In Kaggle"></a><br> | <a href="https://gradient.run/notebook/github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-04-probability-theory/01-what-is-probability.ipynb"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Open In Gradient"></a><br> | <a href="https://studiolab.sagemaker.aws/import/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-04-probability-theory/01-what-is-probability.ipynb"><img src="https://studiolab.sagemaker.aws/studiolab.svg" alt="Open In Studio Lab"></a><br> |
| <ul><li>Chapter 19, Random Variables and Distributions</li></ul> | <a href="https://colab.research.google.com/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-04-probability-theory/02-random-variables-and-distributions.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"></a><br> | <a href="https://www.kaggle.com/kernels/welcome?src=https://github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-04-probability-theory/02-random-variables-and-distributions.ipynb"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Open In Kaggle"></a><br> | <a href="https://gradient.run/notebook/github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-04-probability-theory/02-random-variables-and-distributions.ipynb"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Open In Gradient"></a><br> | <a href="https://studiolab.sagemaker.aws/import/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-04-probability-theory/02-random-variables-and-distributions.ipynb"><img src="https://studiolab.sagemaker.aws/studiolab.svg" alt="Open In Studio Lab"></a><br> |
| <ul><li>Chapter 20, The Expected Value</li></ul> | <a href="https://colab.research.google.com/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-04-probability-theory/03-expected-value.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"></a><br> | <a href="https://www.kaggle.com/kernels/welcome?src=https://github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-04-probability-theory/03-expected-value.ipynb"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Open In Kaggle"></a><br> | <a href="https://gradient.run/notebook/github.com/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-04-probability-theory/03-expected-value.ipynb"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Open In Gradient"></a><br> | <a href="https://studiolab.sagemaker.aws/import/github/cosmic-cortex/mathematics-of-machine-learning-book/blob/main/part-04-probability-theory/03-expected-value.ipynb"><img src="https://studiolab.sagemaker.aws/studiolab.svg" alt="Open In Studio Lab"></a><br> |

</details>


<details open> 
  <summary><h2>Requirements for this book</summary>

  You can run these Jupyter notebooks on remotely on cloud platforms like Google Colab, or locally on your machine. If you decide to run them virtually, you should create a virtual environment first:

```
virtualenv .venv
```

After the enviromnment is created, activate it and install the required Python packages.

```
source .venv/bin/activate
pip install -r requirements.txt
```

  </details>
    


<details> 
  <summary><h2>Get to know Author</h2></summary>

_Tivadar Danka_ is a mathematician by training, a machine learning engineer by profession, and an educator by passion. After finishing his PhD in 2016 (about the arcane subject of orthogonal polynomials), he switched career paths and has been working in machine learning ever since. His work includes applying deep learning to cell microscopy images to identify and phenotype cells, creating one of the most popular open source Python packages for active learning, building a full machine learning library from scratch, and collecting about a total of 100k followers on social media, all by posting high-quality educational content.



</details>
<details> 
  <summary><h2>Other Related Books</h2></summary>
<ul>

  <li><a href="https://www.packtpub.com/en-us/product/machine-learning-with-pytorch-and-scikit-learn-9781801816380">Machine Learning with PyTorch and Scikit-Learn, First Edition</a></li>

  <li><a href="https://www.packtpub.com/en-us/product/python-machine-learning-by-example-9781835082225">Python Machine Learning By Example, Fourth Edition</a></li>
 
</ul>

</details>
