classdef LampsNSWEclass % needs / u?ywa ColorLampClass<LampSuperclass
% Visualisation of 4 traffic lights / Wizualizacja zmiany 4 ?wiate? drogowych
properties
lampN, lampS, lampW, lampE
end
methods
function obj=LampsNSWEclass(X,Y)
obj=map2(obj); % draws simplified map / rysuje skrzy?owanie
obj.lampN=ColorLampClass(X(1),Y(1)); % create / tworzy lampy
obj.lampS=ColorLampClass(X(2),Y(2));
obj.lampW=ColorLampClass(X(3),Y(3));
obj.lampE=ColorLampClass(X(4),Y(4));
end
function obj=gray2flash(obj) % flash yellow / ?te migaj?ce
obj=yellow2all(obj);
pause(.6)
obj=yellow2gray(obj);
pause(.3)
end
function obj=yellow2gray(obj) % yellow off / gasi ?te
set(obj.lampN.Ly,'FaceColor',obj.lampN.color05);
set(obj.lampS.Ly,'FaceColor',obj.lampS.color05);
set(obj.lampW.Ly,'FaceColor',obj.lampW.color05);
set(obj.lampE.Ly,'FaceColor',obj.lampE.color05);
end
function obj=rgb2all(obj)
%% green for NS on road crossing / zielone dla pnoc-poudnie
obj=green2NS(obj);
pause(2)
%% yellow for All / ?te
obj=yellow2all(obj);
pause(.5)
%% green for WE on road crossing / zielone dla wschd-zachd
obj=green2WE(obj);
pause(2)
%% yellow for All / ??te
obj=yellow2all(obj);
pause(.5)
end
function obj=gray2all(obj) %% all lights off /gasi wszystkie lampy
obj.lampN=gray(obj.lampN); obj.lampS=gray(obj.lampS);
obj.lampE=gray(obj.lampE); obj.lampW=gray(obj.lampW);
end
function obj=green2NS(obj) % NS Green / zielone dla pnoc-poudnie
obj.lampN=red(obj.lampN); obj.lampS=red(obj.lampS);
obj.lampE=green(obj.lampE); obj.lampW=green(obj.lampW);
end
function obj=green2WE(obj) % WE green / zielone dla wschd-zachd
obj.lampN=green(obj.lampN); obj.lampS=green(obj.lampS);
obj.lampE=red(obj.lampE); obj.lampW=red(obj.lampW);
end
function obj=yellow2all(obj) % yellow for All / ?te
obj.lampN=yellow(obj.lampN); obj.lampS=yellow(obj.lampS);
obj.lampE=yellow(obj.lampE); obj.lampW=yellow(obj.lampW);
end
function obj=map2(obj)
% draws simplified map of roads / rysuje uproszczone skrzy?owanie
g9=[0.9 0.9 0.8];
rectangle('Position',[4,4,7,6.7],'FaceColor',g9,...
'Curvature',0.1);
rectangle('Position',[15,4,7,6.7],'FaceColor',g9,...
'Curvature',0.1);
rectangle('Position',[15,15.3,7,6.7],'FaceColor',g9,...
'Curvature',0.1);
rectangle('Position',[4,15.3,7,6.7],'FaceColor',g9,...
'Curvature',0.1);
line([4,22],[13,13],'LineStyle','-');
line([13,13],[4,22],'LineStyle','-');
end
end
end