%% 2.5.3. Przyklady operacji macierzowych i tablicowych
% Mnozenie wektorw (poprawne i niepoprawne) oraz mnozenie tablicowe.
x=[1 2 3 ]; y=[4 5 6]; % zdefiniowano dwa wektory
disp('x*y --- dzialanie jest niewykonalne: Inner matrix dimensions must agree')
% Error using *,Inner matrix dimensions must agree
xyt=x*y' % y', czyli transponowane y jest wektorem pionowym, wynikiem mnozenia jest jedna liczba
A=x'*y % wynikiem mnozenia wektora pionowego i poziomego jest macierz kwadratowa
xytab=x.*y % mnozenie tablicowe  wynikiem jest wektor, zachowano rozmiary wektorw

%% 2.5.3-2 Dzielenie tablicowe wektora przez wektor x o tej samej dlugosci.
x=-10:pi/10:16*pi; % generuje wektor x = 10, 10+pi/10, 10+2*pi/10,
y = sin(x)./x; % oblicza wartosc y=sin(x)/x dla kazdego elementu wektora x
% Rezultat to dwa wektory x, y o tych samych wymiarach 1192, uzyte do wykonania wykresu w przykladzie 2.2.9-1. 
% Ewentualne dzielenie przez zero da wynik NaN (ang. not a number)
% NaN jest widoczne jako nieciaglosc (dziura) na wykresie.Rozdzia? 

%% 2.5.3-3 Mnozenie macierzowe (poprawne i niepoprawne). 
% Macierze A, B wprowadzono z klawiatury do przestrzeni roboczej, 
% po czym wykonano mnozenie macierzowe C=A*B i tablicowe C=A.*B.
A= [1 2 3; 4 5 6] % dane
B= [1 1 1; 2 2 2; 3 3 3] % dane
C=A*B % mnozenie macierzowe: identyczne dlugosci wiersza A i kolumny B
disp('B*A mnozenie niewykonalne, dlugosc wiersza B inna niz kolumny A')
% D=B*A % mnozenie niewykonalne, d?ugosc wiersza B inna niz kolumny A
