/*
 * Jeżeli nie podano żadnych parametrow tworzona jest macierz gry 2x2 Jezeli
 * podano jeden argument to moze to byc tablica dwuwymiarowa albo macierz klasy
 * GameMatrix. Dane z nich sa przejmowane do tej macierzy. Jesli sa dwa
 * argumenty: albo podana jest tablica 1-wymiarowa, a jako drugi argument -
 * liczba kolumn albo podane sa rows i cols oznaczajace kolejno liczbe rzedow i
 * liczbe kolumn w macierzy.
 */
function GameMatrix() {
	switch (arguments.length) {
	case 0:
		this.rows = 2;
		this.cols = 2;
		this.array = new Array(this.rows);
		for ( var i = 0; i < this.rows; i++) {
			this.array[i] = new Array(this.cols);
		}
		this.setToValue(0.0);
		break;
	case 1:
		if (arguments[0] instanceof Array) {
			this.array = arguments[0];
			this.rows = this.array.length;
			this.cols = this.array[0].length;
		} else if (arguments[0] instanceof GameMatrix) {
			this.array = arguments[0].array;
			this.rows = arguments[0].rows;
			this.cols = arguments[0].cols;
		}
		break;
	case 2:
		if (arguments[0] instanceof Array) {
			this.array = oneToTwo(arguments[0], arguments[1]);
			this.rows = this.array.length;
			this.cols = this.array[0].length;
		}
		if (typeof arguments[0] === "number") {
			this.rows = arguments[0];
			this.cols = arguments[1];
			this.array = new Array(this.rows);
			for ( var i = 0; i < this.rows; i++) {
				this.array[i] = new Array(this.cols);
			}
			this.setToValue(0.0);
		}
		break;
	}
};
/*
 * Ustawia wszystkie wartości w macierzy na wartość s. Najczęściej jest to 0.
 */
GameMatrix.prototype.setToValue = function(s) {
	for ( var i = 0; i < this.rows; i++) {
		for ( var j = 0; j < this.cols; j++) {
			this.array[i][j] = s;
		}
	}
};
GameMatrix.prototype.gameMin = function() {
	var min = 1000000000000000.0;
	for ( var i = 0; i < this.rows; i++) {
		for ( var j = 0; j < this.cols; j++) {
			min = Math.min(min, this.array[i][j]);
		}
	}
	return min;
};
GameMatrix.prototype.gameMax = function() {
	var max = -1000000000000000.0;
	for ( var i = 0; i < this.rows; i++) {
		for ( var j = 0; j < this.cols; j++) {
			max = Math.max(max, this.array[i][j]);
		}
	}
	return max;
};
GameMatrix.prototype.maximin = function() {
	var min = 1000000000000000.0;
	var max = -1000000000000000.0;
	var maxim = null;
	var arr = new Array(this.rows);
	var arr1 = null;

	for ( var i = 0; i < this.rows; i++) {
		arr1 = this.array[i];
		for ( var j = 0; j < arr1.length; j++) {
			min = Math.min(min, arr1[j]);
		}
		for ( var k = 0; k < arr1.length; k++) {
			if (arr1[k] === min) {
				arr[i] = new Cell(i, k, min);
				min = 1000000000000000.0;
				break;
			}
		}
	}
	for ( var m = 0; m < arr.length; m++) {
		max = Math.max(max, arr[m].val);
	}
	for ( var n = 0; n < arr.length; n++) {
		if (max === arr[n].val) {
			maxim = arr[n];
		}
	}
	return maxim;
};

GameMatrix.prototype.minimax = function() {
	var min = 1000000000000000.0;
	var max = -1000000000000000.0;
	var minim = null;
	var arr = new Array(this.cols);
	var arr1 = new Array(this.rows);
	for ( var i = 0; i < this.cols; i++) {
		for ( var o = 0; o < this.rows; o++) {
			arr1[o] = this.array[o][i];
		}

		for ( var j = 0; j < arr1.length; j++) {
			max = Math.max(max, arr1[j]);
		}

		for ( var k = 0; k < arr1.length; k++) {
			if (arr1[k] === max) {
				arr[i] = new Cell(k, i, max);
				max = -1000000000000000.0;
				break;
			}
		}

	}
	for ( var m = 0; m < arr.length; m++) {
		min = Math.min(min, arr[m].val);
	}
	for ( var n = 0; n < arr.length; n++) {
		if (min === arr[n].val) {
			minim = arr[n];
		}
	}
	return minim;
};
function Cell(row, col, val) {
	this.row = row;
	this.col = col;
	this.val = val;
};
Cell.prototype.toString = function() {
	return "[" + this.row + "," + this.col + "," + this.val + "]";
};
GameMatrix.prototype.hasSaddle = function() {
	var cell1 = this.maximin();
	var cell2 = this.minimax();
	if (cell1.val === cell2.val) {
		return true;
	}
	return false;
};
GameMatrix.prototype.getSaddle = function() {
	if (this.hasSaddle()) {
		return this.maximin();
	}
	return null;
};
GameMatrix.prototype.getRowFreq = function() {
	var arr = new Array(2);
	switch (this.rows) {
	case 2:
		if (this.cols === 2) {
			arr[0] = Math.abs(this.array[1][0] - this.array[1][1]);
			arr[1] = Math.abs(this.array[0][0] - this.array[0][1]);
		}
		break;
	}
	return arr;
};
GameMatrix.prototype.getColFreq = function() {
	var arr = new Array(2);
	switch (this.cols) {
	case 2:
		if (this.rows === 2) {
			arr[0] = Math.abs(this.array[0][1] - this.array[1][1]);
			arr[1] = Math.abs(this.array[0][0] - this.array[1][0]);
		}
		break;
	}
	return arr;
};
GameMatrix.prototype.price = function() {
	var saddle = this.getSaddle();
	var arr1 = null;
	var price = 0.0;
	if (saddle !== null) {
		return saddle.val;
	} else {
		arr1 = this.getRowFreq();
		price = ((arr1[0] * this.array[0][0]) + (arr1[1] * this.array[1][0]))/ (arr1[0] + arr1[1]);
	}
	return price;
};

GameMatrix.prototype.isColDominating = function(colIndex1, colIndex2) {
	var icd = true;
	for ( var i = 0; i < this.rows; i++) {
		if (this.array[i][colIndex1] >= this.array[i][colIndex2]) {
			continue;
		} else {
			icd = false;
			break;
		}
	}
	return icd;
};

GameMatrix.prototype.isRowSubordinated = function(rowIndex1, rowIndex2) {
	var icd = true;
	for ( var i = 0; i < this.cols; i++) {
		if (this.array[rowIndex1][i] <= this.array[rowIndex2][i]) {
			continue;
		} else {
			icd = false;
			break;
		}
	}
	return icd;
};
// kopiuje tablice tej macierzy i zwraca nowa identyczna tablice
GameMatrix.prototype.cloneArray = function() {
	var ar = new Array(this.rows);
	for ( var k = 0; k < this.rows; k++) {
		ar[k] = new Array(this.cols);
	}
	for ( var i = 0; i < this.rows; i++) {
		for ( var j = 0; j < this.cols; j++) {
			ar[i][j] = this.array[i][j];
		}
	}
	return ar;
};

var subgamer = function(gameArray, rowIndex) {
	var ar = gameArray.cloneArray();
	ar = shortenArray(ar, rowIndex);
	var gm = new GameMatrix(ar);
	return gm;
};
var subgamec = function(gameArray, colIndex) {
	var ar = gameArray.cloneArray();
	for ( var i = 0; i < ar.length; i++) {
		ar[i] = shortenArray(ar[i], colIndex);
	}
	var gm = new GameMatrix(ar);
	return gm;
};
// skraca tablice pojedyncza wycinajac z niej podany element
var shortenArray = function(array, index) {
	for ( var i = index + 1; i < array.length; i++) {
		array[i - 1] = array[i];
	}
	array.pop();
	return array;
};

// oblicza oczekiwana (srednia) wartosc wyplaty
// podajemy: tablice wyplat; np. [5, 7, 3];
// tablica czestosci (proporcji) tych wyplat [1, 3, 1], czyli
// 1:3:1
// zwraca srednia wyplate.
var average = function(wyplaty, proporcje) {
	var result = 0.0;
	if (wyplaty.length === proporcje.length) {
		var tempSum1 = 0.0;
		var tempSum2 = 0.0;
		for ( var i = 0; i < wyplaty.length; i++) {
			tempSum1 += proporcje[i];
			tempSum2 += wyplaty[i] * proporcje[i];
		}
		result = tempSum2 / tempSum1;
	} else {
		throw new Error("tablice maja różne długości");
	}
	return result;
};
