var fi = function() {
	return (Math.sqrt(5) + 1) / 2;
};
/**
 * zwraca największy wspólny dzielnik dwóch liczb
 * @param a pierwsza liczba
 * @param b druga liczba
 * @return największy wspólny dzielnik
 */
var nwd = function(a, b) {
	var temp;
	if (b === 0) {
		return a;
	} else {
		temp = nwd(b, a % b);
	}
	return temp;
};

function Fibo(n) {
	if ((n >= 0) && (n < 93)) {
		this.n = n;
		this.fibo = fibonacci(n);
	} else {
		throw new Error("Liczba przekracza dopuszczalny zakres");
	}
}

// wstawiamy dwie tablice 2x2
var multi = function(a, b) {
	var t = new Array(4);
	t[0] = (a[0] * b[0]) + (a[1] * b[2]);
	t[1] = (a[0] * b[1]) + (a[1] * b[3]);
	t[2] = (a[2] * b[0]) + (a[3] * b[2]);
	t[3] = (a[2] * b[1]) + (a[3] * b[3]);
	return t;
};

/**
 * @param n który wyraz ciagu Fibonnacciego
 * @return liczba Fibonacciego
 */
var fibonacci = function(n) {
	var tabl = new Array(1, 1, 1, 0);
	var tablKonc = new Array(1, 1, 1, 0);
	if (n === 0) {
		return 0;
	}
	if (n === 1) {
		return 1;
	}
	for ( var i = 0; i < n; i++) {
		tablKonc = multi(tablKonc, tabl);
	}
	return tablKonc[3];
};

/**
 * 
 * @param liczba - pewna liczba
 * @return - najbliższa liczba Fibonnaciego większa od tej liczby
 */
var biggerFibo = function(liczba) {
	var tabl = new Array(1, 1, 1, 0);
	var tablKonc = new Array(1, 1, 1, 0);
	var b = true;
	while (b === true) {
		tablKonc = multi(tablKonc, tabl);
		b = tablKonc[3] < liczba;
	}
	return tablKonc[3];
};

var isFibo = function(liczba) {
	var tabl = new Array(1, 1, 1, 0);
	var tablKonc = new Array(1, 1, 1, 0);
	var b = true;
	while (b === true) {
		tablKonc = multi(tablKonc, tabl);
		b = tablKonc[3] < liczba;
	}
	if (tablKonc[3] === liczba) {
		return true;
	}
	return false;
};

/**
 * Sumuje cyfry w tej liczbie
 * @param {type} fibo
 * @returns {Number}
 */
var sumaCyfr = function(fibo) {
	var bi = 0;
	var str = String.valueOf(fibo);
	var len = str.length;
	for ( var i = 0; i < len; i++) {
		bi += parseInt(str.substring(i, i + 1));
	}
	return bi;
};

var numSumaCyfr = function(str) {
	var sum = 0;
	var len = str.length();
	for ( var i = 0; i < len; i++) {
		var temp = str.substring(i, i + 1);
		sum += parseInt(temp);
		if (sum > 9) {
			var temp1 = String.valueOf(sum);
			var i1 = parseInt(temp1.substring(0, 1));
			var i2 = parseInt(temp1.substring(1, 2));
			var sum2 = i1 + i2;
			sum = sum2;
		}
	}
	return sum;
};

/**
 * @param liczba - pewna liczba
 * @return najbliższa liczba Fibonacciego mniejsza niż ta liczba
 */
var smallerFibo = function(liczba) {
	var tabl = new Array(1, 1, 1, 0);
	var tablKonc = new Array(1, 1, 1, 0);
	var b = true;
	var i = 0;
	while (b === true) {
		tablKonc = multi(tablKonc, tabl);
		i++;
		b = tablKonc[3] < liczba;
	}
	return new Fibo(i - 1).getFibo();
};

/**
 * rozklada liczbe na sume liczb Fibonacciego
 * @param liczba do rozlozenia
 * @return arraylista liczb, ktorych suma jest rowna liczbie
 */
var rozklad = function(liczba) {
	var al = new Array();
	if (isFibo(liczba)) {
		al.push(liczba);
		return al;
	}
	var stara = liczba;// 100,
	var a = true;
	while (a) {
		var smaller = smallerFibo(stara);// 89,
		stara -= smaller;// 11,
		if (isFibo(stara)) {
			al.push(smaller);
			al.push(stara);
			return al;
		} else {
			al.push(smaller);
		}
	}
	return al;
};

var getFibos = function(min, max) {
	var list = new Array();
	for ( var j = min + 1; j < max; j++) {
		if (isFibo(j)) {
			list.push(j);
		}
	}
	return list;
};

Fibo.prototype.getFibo = function() {
	return this.fibo;
};

Fibo.prototype.getN = function() {
	return n;
};

Fibo.prototype.toString = function() {
	return "[" + this.n + ", " + this.fibo + "]";
};
var factorial2 = function(x) {
	if (x === 0) {
		return 1;
	} else {
		return x * factorial(x - 1);
	}
};
var factorial = function(n) {
	if (n > 18) {
		throw new Error("zbyt duża liczba");
	}
	if (n === 0) {
		return 1;
	}
	var sum = 1;
	for ( var i = 1; i < n + 1; i++) {
		sum *= i;
	}
	return sum;
};
var npok = function(n, k) {
	if (k > n) {
		return 0;
	} else if (k === 0 || k === n) {
		return 1;
	} else if (k === 1 || k === (n - 1)) {
		return n;
	} else {
		var b = factorial(k);
		var c = factorial(n - k);
		var a = b;
		for ( var i = k + 1; i < n + 1; i++) {
			a *= i;
		}
		return a / (b * c);
	}
};
var log10 = function(x) {
	return Math.LOG10E * Math.log(x);
};
var anylog = function(dane, podstawa) {
	return log10(dane) / log10(podstawa);
};
var numer = function(liczba) {
	var x = Math.sqrt(5) * liczba + 0.5;
	return cutDecimal(anylog(x, fi()));
};
var cutDecimal = function(nr) {
	var temp = nr.toString();
	var temp1 = temp.indexOf(".");
	var temp2 = "";
	if (temp1 > -1) {
		temp2 = temp.substr(0, temp1);
	} else {
		temp2 = temp;
	}
	return parseInt(temp2);
};