var cv = document.getElementById('canvas');
var ctx = cv.getContext('2d');
var width = cv.width;
var height = cv.height;
var liczbaPol = 25;
var szer = 32;// odleglosc miedzy liniami = szerokosc komorki


function Sito(milis) {
	this.milis = milis;
	this.n = liczbaPol * liczbaPol;
	this.k = 2;
	this.nn = Math.floor(Math.sqrt(this.n)); 
	this.primes = new Array(this.n + 1);	
	for ( var i = 0; i < this.primes.length; i++) {
		this.primes[i] = true;		
	};
	this.primes[0] = false;
	this.primes[1] = false;	
	
}
Sito.prototype.actualize = function() {
	if(this.k <= this.nn){
		for(var i = 2 * this.k; i < this.n + 1; i = i + this.k){
			this.primes[i] = false;
		}
		for(var j= this.k + 1; j < this.n + 1; j++){
			if(this.primes[j]){
				this.k=j;
				break;
			}			
		}		
	} 	
};
Sito.prototype.drawSito = function() {
	this.actualize();
	ctx.save();
	ctx.clearRect(0, 0, 800, 800);
	ctx.beginPath();
	ctx.strokeStyle = "rgb(200,200,200)";
	var z = 0;// polozenie linii
	for ( var i = 0; i <= liczbaPol; i++) {
		ctx.moveTo(0, z);
		ctx.lineTo(width, z);
		ctx.moveTo(z, 0);
		ctx.lineTo(z, width);
		z += szer;
	}
	ctx.stroke();
	ctx.beginPath();	
	for(var a = 0 ; a< this.primes.length;a++){
		var t = this.obliczRowCol(a, liczbaPol);
		var x = t[0] * szer;
		var y = t[1] * szer;
		if(this.primes[a]){
			ctx.fillStyle = "rgb(0,0,0)";
			ctx.fillText(a, y+8, x+20);
		}else{
			ctx.fillStyle = "rgb(140,140,140)";
			ctx.fillRect(y+1,x+1, szer-2, szer-2);
		}
	};	
	ctx.fill();
	ctx.restore();	
};
Sito.prototype.obliczRowCol = function(indeks, cols) {
	var row = Math.floor(indeks / cols);
	var col = indeks % cols;
	var tab = new Array(row, col);
	return tab;
};


