function FrequencyArray() {
    this.array = new Object();
};
FrequencyArray.prototype.add = function (item) {
    if (this.array[item.toString()]) {
        this.array[item.toString()] += 1;
    } else {
        this.array[item.toString()] = 1;
    }
};
FrequencyArray.prototype.remove = function (item) {
    if (this.array[item.toString()]) {
        if (this.array[item.toString()] === 1) {
            delete this.array[item.toString()];
        } else {
            this.array[item.toString()] -= 1;
        }
    }
};
FrequencyArray.prototype.getAllAsVectors = function () {
    var vects = new Array();
    var i = 0;
    for (var p in this.array) {
        vects[i] = new Vector2f(parseInt(p), this.array[p]);
        i++;
    }
    return vects;
};
FrequencyArray.prototype.getAllAsVectors2 = function () {
    var vects = new Array();
    var i = 0;
    for (var p in this.array) {
        vects[i] = new Vector2f(p, this.array[p]);
        i++;
    }
    return vects;
};
FrequencyArray.prototype.getAllAsNumbers = function () {
    var numbs = new Array();
    var j = 0;
    for (var p in this.array) {
        for (var i = 0; i < this.array[p]; i++) {
            numbs[j] = parseInt(this.array[p]);
            j++;
        }
    }
    return numbs;
};
var amod = function (index, modulus) {
    var i = index;
    i = i % modulus;
    if (i === 0) {
        i = modulus;
    }
    if (i < 0) {
        i = (modulus + i);
    }
    return i;
};
// ------------------------- arytmetyka modularna ------------------------
/**
 * Wykonuje mnożenie modularne
 * 
 * @param a liczba a
 * @param b liczba b
 * @param m modulus
 * @return a*b (mod m)) faktycznie funkcja wykonuje mnożenie a*b = c potem
 *         oblicza c%m, ale ta funkcja wykonuje to szybciej
 */
var multMod = function (a, b, m) {
    var wynik = 0;
    while (a > 0) {
        if ((a & 1) === 1) {
            wynik += b;
            wynik %= m;
        }
        b <<= 1;
        b %= m;
        a >>= 1;
    }
    return wynik;
};

/**
 * Wykonuje potęgowanie modularne
 * @param a liczba a
 * @param b liczba b
 * @param m modulus
 * @return wynik potęgowania modularnego. Właściwie funkcja podnosi a do potęgi
 *         b = c oblicza c%modulus, ale wykonuje to szybciej
 */
var powerMod = function (a, b, m) {
    var wynik = 1;
    while (b > 0) {
        if ((b & 1) === 1) {
            wynik = multMod(wynik, a, m);
        }
        a = multMod(a, a, m);
        b >>= 1;
    }
    return wynik;
};

// ------------------------- generowanie liczb ---------------------------
/**
 * zwraca pierwszą liczbę pierwszą większą od podanej liczby
 * @param min - liczba progowa
 * @return pierwsza liczba pierwsza większa od min
 */
var getPrime = function (min) {
    for (var j = min + 1; true; j++) {
        if (isPrime(j)) {
            return j;
        }
    }
};

/**
 * Generuje liczbę pierwszą Eulera
 * @param n - liczba wyjściowa
 * @return
 */
var euler = function (n) {
    return Math.pow(n, 2) - 79 * n + 1601;
};

/**
 * oblicza liczby pierwsze w podanym zakresie
 * @param min - pierwsza liczba
 * @param max - większa liczba
 * @return tablica liczb pierwszych leżących między min, a max
 */
var getPrimes = function (min, max) {
    var list = [];
    var i = 0;
    for (var j = min + 1; j < max; j++) {
        if (isPrime(j)) {
            list[i] = j;
            i++;
        }
    }
    return list;
};

/**
 * Sito Erastotenesa
 * @param max - liczba maksymalna
 * @return tablicę booleanów, w korej indeks oznacza liczbę a wartość true w
 *         komórce - liczbę pierwsza, Gdy wartość w komórce jest false - liczba
 *         nie jest pierwsza
 */
var sitoEratostenesa = function (max) {
    var pol = (max + 1) >> 1;
    var wynik = new Array(max + 1);
    for (var i = 2; i <= max; ++i){
        wynik[i] = true;    	
    }
    var p = 2;
    while (p < pol) {
        for (var z = p << 1; z <= max; z += p){
            wynik[z] = false;        	
        }
        while ((++p < pol) && (!wynik[p]));
    }
    return wynik;
};

/**
 * Oblicza liczbę Mersenna = Math.pow(2, exp)-1
 * @param {int} exp - wykładnik potęgi
 * @returns {Number} wygenerowana liczba Mersenne'a 
 */
var mersenne = function (exp) {
    var p = 1;
    for (var i = 1; i <= exp; ++i) {
        p += p;
    }
    p -= 1;
    return p;
};

// --------------------- sprawdzanie pierwszości ------------------------
/**
 * sprawdza czy podana liczba jest liczbą pierwszą
 * @param n - liczba do zbadania
 * @return zwraca true jeśli badana liczba jest liczbą pierwszą, a false w
 * przeciwnym wypadku
 */
var isPrime = function (n) {
    for (var j = 2; Math.pow(j, 2) <= n; j++) {
        if (n % j === 0) {
            return false;
        }
    }
    return true;
};

/**
 * Test pierwszości liczby
 * @param p - liczba do przetestowania
 * @param iters - liczba iteracji - najlepiej około 1000;
 * @return false jeśli liczba nie jest pierwsza i jest to całkowicie pewne,
 *         true, jeśli liczba jest pierwsza (z bardzo dużym prawdopodobieństwem
 *         zależnym od liczby iteracji - im więcej iteracji tym większe
 *         prawdopodobieństwo, że liczba jest pierwsza)
 */
var testMillerRabin = function (p, iters) {
    var a = p - 1;
    var b = 0;
    var c = 0;
    while ((a & 1) === 0) {
        a >>= 1;
        ++b;
    }
    for (var i = 0; i < iters; ++i) {
        c = randomInRange(0, p);
        if (!millerRabinPomoc(a, b, c, p)) {
            return false;
        }
    }
    return true;
};

/**
 * Metoda pomocnicza dla testu Millera - Rabina
 * @param {type} a
 * @param {type} b
 * @param {type} c
 * @param {type} d
 * @returns {Boolean}
 */
var millerRabinPomoc = function (a, b, c, d) {
    var h = 0;
    var e = d - 1;
    var f = b - 1;
    var g = powerMod(c, a, d);
    if (g === 1) {
        return true;
    }
    while (g !== e) {
        if (h > f) {
            return false;
        }
        g = powerMod(g, 2, d);
        if (g === 1) {
            return false;
        }
    }
    return true;
};

// ------------------------------- faktoryzacja --------------------------
var cutDecimal = function (nr) {
    var temp = nr.toString();
    var temp1 = temp.indexOf(".");
    var temp2 = "";
    if (temp1 > -1) {
        temp2 = temp.substr(0, temp1);
    } else {
        temp2 = temp;
    }
    return parseInt(temp2);
};
/**
 * Rozkłada liczbę na iloczyn liczb pierwszych
 * @param n - liczba do rozłożenia
 * @return - tablice punktow. W kazdym punkcie x oznacza liczbą, a y liczbe
 *         wystąpień tej liczby w iloczynie. Jeśli x = 2, a y = 3 to mamy 2 x 2
 *         x 2 x natępny punkt;
 */
var factorize1 = function (n) {
    var sqrt = cutDecimal(Math.sqrt(n));
    if (n < 10) {
        sqrt++;
    }
    if (n < 2) {
        return new Vector2f(1, 1);
    }
    var primes = getPrimes(1, sqrt);
    var fm = new FrequencyArray();
    for (var i = 0; i < primes.length; i++) {
        var p = primes[i];
        while (n % p === 0) {
            fm.add(p);
            n /= p;
        }
        if (n === 1) {
            break;
        }
    }
    if (n > 1) {
        fm.add(n);
    }
    var vects = fm.getAllAsVectors();
    return vects;
};

/**
 * To samo co factorize1, ale zwraca tablicęe intów zawierającą liczby, kóre
 * należy pomnożyć przez siebie, (mnożniki) aby otrzymać liczbę rozkładaną na
 * czyniki
 * @param {type} n
 * @returns {Array}
 */
var factorize2 = function (n) {
    var points = new Array();
    var sqrt = cutDecimal(Math.sqrt(n));
    if (n < 10) {
        sqrt++;
    }
    if (n < 2) {
        points[0] = 1;
        return points;
    }
    var primes = getPrimes(1, sqrt);
    var fm = new FrequencyArray();
    for (var i = 0; i < primes.length; i++) {
        var p = primes[i];
        while (n % p === 0) {
            fm.add(p);
            n /= p;
        }
        if (n === 1) {
            break;
        }
    }
    if (n > 1) {
        fm.add(n);
    }
    points = fm.getAllAsNumbers();
    return points;
};

/**
 * Tak samo jak factorize1, ale wynik podany jest w postaci stringu pokazującego
 * liczbę i podział tej liczby na składniki
 * @param {type} n
 * @returns {factorize3.str|String}
 */
var factorize3 = function (n) {
    var str = "" + n;
    var sqrt = cutDecimal(Math.sqrt(n));
    if (n < 10) {
        sqrt++;
    }
    if (n < 2) {
        return "1(1)";
    }
    var primes = getPrimes(1, sqrt);
    var fm = new FrequencyArray();
    for (var i = 0; i < primes.length; i++) {
        var p = primes[i];
        while (n % p === 0) {
            fm.add(p);
            n /= p;
        }
        if (n === 1) {
            break;
        }
    }
    if (n > 1) {
        fm.add(n);
    }
    var points = fm.getAllAsVectors();
    str = str.concat("(");
    for (var i = 0; i < points.length - 1; i++) {
        str = str.concat(points[i] + " x ");
    }
    str = str.concat(points[points.length - 1]);
    str = str.concat(")");
    fm = null;
    return str;
};

// ------------------------------- inne ----------------------------------
/**
 * Podaje losową liczbę z przedziału zamkniętego <min, max>
 * @param min int - najmniejsza wartość
 * @param max int - największa wartość
 * @return int - wylosowana wartość z podanego zakresu, z uwzględniem min i max
 */
var randomInRange = function (min, max) {
    var random = -1;
    if (min > max) {
        throw new Error("pierwsza liczba musi być mniejsza od drugiej");
    } else {
        random = cutDecimal(Math.floor(Math.random() * (max - min + 1)) + min);
    }
    return random;
};

var lastDigits = function (x, howMany) {
    var temp = String.valueOf(x);
    var len = temp.length();
    if (howMany > len) {
        howMany = len;
    }
    var sub = null;
    for (var i = 0; i < howMany; i++) {
        sub = temp.substring(len - howMany, len);
    }
    return parseInt(sub);
};
