var w = cv.width;
var h = cv.height;
var x0 = w / 2.0;
var y0 = h / 2.0;
var lw = 0.5;
var bw = 12;
var bh = 10;
var cl = true;
var radius = 0;
var angle = 0;

var Complex = function(re, im) {
	if (arguments.length === 2) {
		this.re = arguments[0];
		this.im = arguments[1];
	}
	if (arguments.length === 1) {
		if (arguments[0] instanceof Polar) {
			this.re = arguments[0].radius * cosDeg(arguments[0].angle);
			this.im = arguments[0].radius * sinDeg(arguments[0].angle);
		}
		if (arguments[0] instanceof Vector2d) {
			this.re = arguments[0].x;
			this.im = arguments[0].y;
		}
	}
};

Complex.prototype.getRe = function() {
	return this.re;
};
Complex.prototype.setRe = function(re) {
	this.re = re;
};
Complex.prototype.getIm = function() {
	return this.im;
};
Complex.prototype.setIm = function(im) {
	this.im = im;
};
/**
 * Sprzężenie liczby zespolonej
 * @return liczbę zespoloną sprzężoną z tą liczbą zespoloną
 */
Complex.prototype.conj = function() {
	return new Complex(this.re, -1.0 * this.im);
};
/**
 * Moduł liczby zespolonej
 * @return - wartość modułu
 */
Complex.prototype.mod = function() {
	return Math.sqrt(this.re * this.re + this.im * this.im);
};

/**
 * Argument liczby zespolonej
 * @return - argument tej liczby
 */
Complex.prototype.arg = function() {
	return radToDeg(Math.atan2(this.im, this.re));
};
/**
 * Dodawanie liczb zespolonych
 * @param other - liczba dodawana
 * @return - liczba zespolona będąca wynikiem dodania other do tej liczby
 */
Complex.prototype.add = function(other) {
	var a = this.re + other.re;
	var b = this.im + other.im;
	return (new Complex(a, b));
};
/**
 * Odejmowanie liczby zespolonej
 * @param other - odejmowana liczba
 * @return - liczba zespolona wbędąca wynikiem odjęcia other od tej liczby
 */
Complex.prototype.sub = function(other) {
	var a = this.re - other.re;
	var b = this.im - other.im;
	return (new Complex(a, b));
};
/**
 * Mnożenie liczb zespolonych
 * @param other - liczba do pomnożenia
 * @return - liczba zespolona będąca wynikiem pomnożenia other przez tę liczbę
 */
Complex.prototype.multi = function(other) {
	var a = this.re * other.re - this.im * other.im;
	var b = this.re * other.im + this.im * other.re;
	return (new Complex(a, b));
};
/**
 * Dzielenie liczb zespolonych
 * @param other - liczba będąca dzielnikiem
 * @return liczba zepsolona będąca wynikiem dzielenia tej liczby przez other
 */
Complex.prototype.div = function(other) {
	var licznik = this.multi(other.conj());
	var mianownik = other.multi(other.conj());
	return new Complex(licznik.getRe() / mianownik.getRe(), licznik.getIm()
			/ mianownik.getRe());
};
Complex.prototype.show = function() {
	if (this.im >= 0) {
		return "[" + this.re + "+" + this.im + "i" + "]";
	} else {
		return "[" + this.re + "" + this.im + "i" + "]";
	}
};
var TComplex = function(r, fi) {
	if (arguments.length === 2) {
		this.r = arguments[0];
		this.fi = arguments[1];
		this.complex = new Complex(r * cosDeg(arguments[1]), r
				* sinDeg(arguments[1]));
	}
	if (arguments.length === 1) {
		if (arguments[0] instanceof Complex) {
			this.r = arguments[0].mod();
			this.fi = arguments[0].arg();
			this.complex = arguments[0];
		}
	}
};
TComplex.prototype.getR = function() {
	return this.r;
};
TComplex.prototype.getFi = function() {
	return this.fi;
};

TComplex.prototype.getComplex = function() {
	return this.complex;
};

/**
 * Mnozenie liczb zespolonych
 * @param other - liczba do pomnożenia
 * @return - liczbę będącą wynikiem mnożenia
 */
TComplex.prototype.multi = function(other) {
	return new TComplex(this.r * other.r, this.fi + other.fi);
};

/**
 * Dzielenie liczb zespolonych
 * @param other - dzielnik
 * @return - wynik dzielenia tej liczby przez other
 */
TComplex.prototype.div = function(other) {
	return new TComplex(this.r / other.getR(), this.fi - other.getFi());
};

/**
 * Potęgowanie liczb zespolonych
 * @param w - stopień potęgi
 * @return - wynik podniesienia tej liczby do potęgi w
 */
TComplex.prototype.pow = function(w) {
	return new TComplex(Math.pow(this.r, w), this.fi * w);
};

/**
 * Pierwiastkowanie liczby zespolonej
 * @param n - stopień pierwiastka
 * @return - tabela liczb zespolonych będących pierwiastkami n-tego stopnia z
 *         tej liczby.
 */
TComplex.prototype.roots = function(n) {
	var tabl = new Array(n);
	for ( var i = 0; i < n; i++) {
		tabl[i] = new TComplex(Math.pow(this.r, 1.0 / n),
				(this.fi + 2 * i * 180.0) / n);
	}
	return tabl;
};

/**
 * Odwrotność tej liczby zespolonej 1.0/this
 * @return - liczbę zespoloną będącą wynikiem dzielenia
 */
TComplex.prototype.rev = function() {
	return new TComplex(1.0 / this.r, -1.0 * this.fi);
};
TComplex.prototype.show = function() {
	var a = "[";
	var b = roundToDecimal(this.r, 3);
	var c = "(";
	var d = "cos";
	var t = roundToDecimal(this.fi, 3);
	var znak = false;
	if (t < 0.0) {
		znak = true;
	}
	var t1 = Math.abs(t);

	while (t1 >= 360.0) {
		t1 -= 360.0;
	}
	if (znak) {
		t1 *= -1.0;
	}
	var e = getDecim(t1);
	var f = "\u00B0";
	var g = getFract(t1);
	var h = " ";
	var i = "+";
	var j = " ";
	var k = "i";
	var l = "sin";
	var m = getDecim(t1);
	var n = "\u00B0";
	var o = getFract(t1);
	var p = ")";
	var r = "]";
	return "" + a + b + c + d + e + f + g + h + i + j + k + l + m + n + o + p
			+ r;
};
function drawComplex(complex, axes, fillStyle) {
	ctx.save();
	ctx.beginPath();
	ctx.fillStyle = fillStyle;
	if (complex instanceof Complex) {
		radius = Math.sqrt(Math.pow(complex.re, 2) + Math.pow(complex.im, 2));
		angle = atan2Deg(complex.im, complex.re);
	}
	if (axes === "complex") {
		drawArrow(x0, y0, radius * 30, lw, angle, bw, bh, cl, fillStyle);

	}
	ctx.restore();

};
function drawTComplex(tcomplex, axes, fillStyle) {
	ctx.save();
	ctx.beginPath();
	ctx.fillStyle = fillStyle;
	if (tcomplex instanceof TComplex) {
		if (axes === "complex") {
			drawArrow(x0, y0, tcomplex.r * 30, lw, tcomplex.fi, bw, bh, cl,
					fillStyle);
		}
	}
	ctx.restore();

};

function radToDeg(radDeg) {
	return radDeg * 180.0 / Math.PI;
};

function degToRad(angleDeg) {
	return Math.PI * angleDeg / 180.0;
};

function cosDeg(angleDeg) {
	return Math.cos(angleDeg * Math.PI / 180);
};

function sinDeg(angleDeg) {
	return Math.sin(angleDeg * Math.PI / 180);
}
var atan2Deg = function(yy, xx) {
	return Math.atan2(yy, xx) * 180.0 / Math.PI;
};
function roundToDecimal(num, dec) {
	var multi = Math.pow(10, dec);
	return Math.round(num * multi) / multi;
};

function getDecim(num) {
	var temp = num.toString();
	var temp2 = temp.substring(0, temp.indexOf("."));
	return temp2;
};

function getFract(num) {
	var temp = num.toString();
	var temp2 = temp.substring(temp.indexOf(".") + 1);
	return temp2;
};