var cv = document.getElementById('canvas');
var ctx = cv.getContext('2d');
var width = cv.width;
var height = cv.height;

// logarytm o dowolnej podstawie także o podstawie 10 lub e
var log = function (b, a) {
    return Math.log(b) / Math.log(a);
};
// scale = liczba oczek siatki w poziomie
// 2 oznacza siatke 2 x 2, 3 = 3 x 3, etc
var drawGrid = function (scale, show) {
    ctx.save();
    ctx.beginPath();
    ctx.lineWidth = 2;
    ctx.moveTo(0, 0);
    ctx.lineTo(width, 0);
    ctx.lineTo(width, height);
    ctx.lineTo(0, height);
    ctx.lineTo(0, 0);
    ctx.stroke();
    ctx.restore();
    if (!show) {
        drawPart(scale, 0.2);
    } else {
        for (var i = 0, j = log(scale, 2) - 1; i < log(scale, 2); i++, j--) {
            drawPart(scale / Math.pow(2, i), 2 / Math.pow(2, j));
        }
    }
};
// metoda pomocnicza do metody drawGrid
var drawPart = function (scale, lineWidth) {
    var szer = width / scale;
    var len = szer * scale;
    ctx.save();
    ctx.beginPath();
    ctx.lineWidth = lineWidth;
    var z = 0;// polozenie linii
    for (var i = 0; i <= scale; i++) {
        ctx.moveTo(0, z);
        ctx.lineTo(len, z);
        z += szer;
    }
    z = 0;
    for (var k = 0; k <= scale; k++) {
        ctx.moveTo(z, 0);
        ctx.lineTo(z, len);
        z += szer;
    }
    ctx.stroke();
    ctx.restore();
};
var drawCantorSet = function (steps) {

    var x = 5;// punkt startu
    var y = 4;// punkt startu
    var wt = width - 2 * x;// szerokość rysunku
    ctx.save();
    ctx.beginPath();
    ctx.lineWidth = 1;
    for (var i = 0; i < steps; i++) {
        y += 20;
        var w = wt / Math.pow(3, i);// długość odcinka
        var coeffs = coeffTable(i + 1);// tablica współczynników
        for (var j = 0; j < coeffs.length; j++) {
            ctx.moveTo(x + coeffs[j] * w, y);
            ctx.lineTo(x + coeffs[j] * w + w, y);
        }
    }
    ctx.stroke();
    ctx.restore();
};
// funkcja pomocnicza dla drawCantorSet
var coeffTable = function (steps) {
    var arr = null;
    if (steps === 1) {
        arr = new Array(1);
        arr[0] = 0;
    } else {
        arr = new Array(2);
        arr[0] = 0;
        arr[1] = 2;
        var x = 2;
        for (var i = 2; i < steps; i++) {
            var arr2 = copyArray(arr);
            for (var j = 0; j < arr2.length; j++) {
                arr2[j] += x * 3;
            }
            arr = arr.concat(arr2);
            x *= 3;
        }
    }
    return arr;
};
var copyArray = function (ar) {
    var arr2 = new Array(ar.length);
    for (var i = 0; i < arr2.length; i++) {
        arr2[i] = ar[i];
    }
    return arr2;
};
var drawKochCurve = function (steps) {
    var x = 5;// punkt startu
    var y = height / 2;// punkt startu
    var wt = width - 2 * x;// szerokość rysunku
    ctx.save();
    ctx.translate(x, y);
    ctx.moveTo(0, 0);
    subflake(--steps, wt);
    ctx.restore();
    ctx.stroke();
};
var subflake = function (steps, wt) {
    ctx.save();
    if (steps === 0) {
        ctx.lineTo(wt, 0);
    } else {
        ctx.scale(1 / 3, 1 / 3);
        subflake(steps - 1, wt);
        ctx.rotate(-1 / 3 * Math.PI);
        subflake(steps - 1, wt);
        ctx.rotate(2 / 3 * Math.PI);
        subflake(steps - 1, wt);
        ctx.rotate(-1 / 3 * Math.PI);
        subflake(steps - 1, wt);
    }
    ctx.restore();
    ctx.stroke();
    ctx.translate(wt, 0);
};
var Vector2f = function (x, y) {
    switch (arguments.length) {
        case 0:
            this.x = 0.0;
            this.y = 0.0;
            break;
        case 2:
            this.x = arguments[0];
            this.y = arguments[1];
            break;
    }
};
Vector2f.prototype.toString = function () {
    return "V=[" + this.x + ", " + this.y + "]";
};
var v1, v2, v3, v4, v5, v6, v7, v8, v9;
var vs = new Array(new Vector2f(0, height), new Vector2f(width, height),
        new Vector2f(width / 2, height - Math.sqrt(3) / 2 * height));
var fillb = "black";
var fillw = "white";
var drawSierpinskiGasket = function (steps) {
    ctx.save();
    ctx.fillStyle = fillb;
    fillSierpinskiGasket(vs);
    ctx.fillStyle = fillw;
    calcSierpinskiGasket(new Vector2f(vs[0].x, vs[0].y), new Vector2f(vs[1].x,
            vs[1].y), new Vector2f(vs[2].x, vs[2].y), steps);
    ctx.restore();
};

var fillSierpinskiGasket = function (vs) {
    ctx.beginPath();
    ctx.moveTo(vs[0].x, vs[0].y);
    ctx.lineTo(vs[1].x, vs[1].y);
    ctx.lineTo(vs[2].x, vs[2].y);
    ctx.closePath();
    ctx.fill();
};
var calcSierpinskiGasket = function (va, vb, vc, steps) {
    if (steps === 0) {
        return;
    }
    steps -= 1;
    var coords = new Array(new Vector2f(vc.x, vb.y), new Vector2f(
            (vc.x + vb.x) / 2, (vc.y + va.y) / 2), new Vector2f(
            (va.x + vc.x) / 2, (vc.y + va.y) / 2));
    fillSierpinskiGasket(coords);
    v1 = va;
    v4 = new Vector2f(vc.x, vb.y);
    v7 = new Vector2f((va.x + vc.x) / 2, (vc.y + va.y) / 2);
    calcSierpinskiGasket(v1, v4, v7, steps);
    v2 = new Vector2f(vc.x, vb.y);
    v5 = vb;
    v8 = new Vector2f((vc.x + vb.x) / 2, (vc.y + va.y) / 2);
    calcSierpinskiGasket(v2, v5, v8, steps);
    v3 = new Vector2f((va.x + vc.x) / 2, (vc.y + va.y) / 2);
    v6 = new Vector2f((vc.x + vb.x) / 2, (vc.y + va.y) / 2);
    v9 = vc;
    calcSierpinskiGasket(v3, v6, v9, steps);
};

var drawDragon = function (start, end, steps, strokeStyle) {
    ctx.save();
    if (steps === 0) {
        ctx.beginPath();
        ctx.strokeStyle = strokeStyle;
        ctx.moveTo(start.x, start.y);
        ctx.lineTo(end.x, end.y);
        ctx.stroke();

    } else {
        var v1 = new Vector2f((start.x + end.x) / 2, (start.y + end.y) / 2);
        var v2 = new Vector2f(v1.x + end.y - v1.y, v1.y + start.x - v1.x);
        ctx.strokeStyle = strokeStyle;
        drawDragon(end, v2, steps - 1);
        drawDragon(start, v2, steps - 1);

    }
    ctx.stroke();
    ctx.restore();
};
function JuliaFractal(iters, re, im, cre, cim) {
    this.min = -1.7;
    this.max = 1.7;
    this.scale = (this.max - this.min) / width;
    this.s = 2.0;
    this.iters = iters;
    this.re = re;
    this.im = im;
    this.cre = cre;
    this.cim = cim;
}
;

JuliaFractal.prototype.liczIter = function (zre1, zim1) {
    var zim = zim1;
    var zre = zre1;
    var kwad = 0.0;
    var licznik = 0;
    while ((kwad < this.s * this.s) && (licznik < this.iters)) {
        var tempr = zre * zre - zim * zim + this.cre;
        var tempz = this.s * zre * zim + this.cim;
        zre = tempr;
        zim = tempz;
        kwad = zim * zim + zre * zre;
        licznik++;
    }
    return this.iters - licznik;
};
JuliaFractal.prototype.index = function (row, col, cols) {
    return row * cols + col;
};
JuliaFractal.prototype.rowCol = function (indeks, cols) {
    var row = cutDecimal(indeks / cols);
    var col = indeks % cols;
    var arr = new Array(row, col);
    return arr;
};
var cutDecimal = function (nr) {
    var temp = nr.toString();
    var temp1 = temp.indexOf(".");
    var temp2 = "";
    if (temp1 > -1) {
        temp2 = temp.substr(0, temp1);
    } else {
        temp2 = temp;
    }
    return parseInt(temp2);
};
JuliaFractal.prototype.drawJulia = function () {
    var img1 = ctx.getImageData(0, 0, width, height);
    var idata = img1.data;
    for (var i = 0; i < idata.length; i += 4) {
        var ar = this.rowCol(i / 4, width);
        var zr = this.min + ar[1] * this.scale;
        var zi = this.min + ar[0] * this.scale;
        var licz = this.liczIter(zr, zi);
        idata[i] = ((licz >> 1) & 0x07) << 5;
        idata[i + 1] = ((licz >> 3) & 0x07) << 5;
        idata[i + 2] = ((licz >> 6) & 0x07) << 5;
        idata[i + 3] = 255;
    }
    ctx.putImageData(img1, 0, 0);
};
// -
function Mandelbrot(iters, re, im, cre, cim) {
    this.min = -2.5;
    this.max = 2.5;
    this.scale = (this.max - this.min) / width;
    this.s = 2.0;
    this.iters = iters;
    this.re = re;
    this.im = im;
    this.cre = cre;
    this.cim = cim;
}
;

Mandelbrot.prototype.liczIter = function (cre, cim) {
    var zim = 0;
    var zre = 0;
    var kwad = 0.0;
    var licznik = 0;
    while ((kwad < this.s * this.s) && (licznik < this.iters)) {
        var tempr = zre * zre - zim * zim + cre;
        var tempz = this.s * zre * zim + cim;
        zre = tempr;
        zim = tempz;
        kwad = zim * zim + zre * zre;
        licznik++;
    }
    return this.iters - licznik;
};
Mandelbrot.prototype.index = function (row, col, cols) {
    return row * cols + col;
};
Mandelbrot.prototype.rowCol = function (indeks, cols) {
    var row = cutDecimal(indeks / cols);
    var col = indeks % cols;
    var arr = new Array(row, col);
    return arr;
};
Mandelbrot.prototype.drawMandelbrot = function () {
    var img1 = ctx.getImageData(0, 0, width, height);
    var idata = img1.data;
    for (var i = 0; i < idata.length; i += 4) {
        var ar = this.rowCol(i / 4, width);
        var cre = this.min + ar[1] * this.scale;
        var cim = this.min + ar[0] * this.scale;
        var licz = this.liczIter(cre, cim);
        idata[i] = ((licz >> 1) & 0x07) << 5;
        idata[i + 1] = ((licz >> 3) & 0x07) << 5;
        idata[i + 2] = ((licz >> 6) & 0x07) << 5;
        idata[i + 3] = 255;
    }
    ctx.putImageData(img1, 0, 0);
};
// -
function BurningShip(iters, re, im) {
    this.min = -2.4;
    this.max = 2.4;
    this.scale = (this.max - this.min) / width;
    this.s = 2.0;
    this.iters = iters;
    this.re = re;
    this.im = im;
}
;

BurningShip.prototype.liczIter = function (cre, cim) {
    var tre = 0;
    var tim = 0;
    var kwad = 0.0;
    var licznik = 0;
    while ((kwad < this.s * this.s) && (licznik < this.iters)) {
        var tempr = tre * tre - tim * tim + cre;
        var tempi = 2 * Math.abs(tre * tim) + cim;
        tre = tempr;
        tim = tempi;
        kwad = tim * tim + tre * tre;
        licznik++;
    }
    return this.iters - licznik;
};
BurningShip.prototype.index = function (row, col, cols) {
    return row * cols + col;
};
BurningShip.prototype.rowCol = function (indeks, cols) {
    var row = cutDecimal(indeks / cols);
    var col = indeks % cols;
    var arr = new Array(row, col);
    return arr;
};
BurningShip.prototype.drawBurningShip = function () {
    var img1 = ctx.getImageData(0, 0, width, height);
    var idata = img1.data;
    for (var i = 0; i < idata.length; i += 4) {
        var ar = this.rowCol(i / 4, width);
        var cre = this.min + ar[1] * this.scale;
        var cim = this.min + ar[0] * this.scale;
        var licz = this.liczIter(cre, cim);
        idata[i] = ((licz >> 3) & 0x07) << 5;
        idata[i + 1] = ((licz >> 3) & 0x07) << 5;
        idata[i + 2] = ((licz >> 5) & 0x07) << 5;
        idata[i + 3] = 255;
    }
    ctx.putImageData(img1, 0, 0);
};
var calculateBarnsley = function (steps) {
    var arr = new Array(steps);
    arr[0] = new Vector2f(0.0, 0.0);
    for (var i = 0; i < steps - 1; i++) {
        var rand1 = Math.random();
        var rand2 = Math.random();
        if (rand1 <= 0.01) {
            arr[i + 1] = new Vector2f(0.0, 0.16 * arr[i].y);
        } else if (rand1 <= 0.15) {
            if (rand2 <= 0.5) {
                arr[i + 1] = new Vector2f(-0.15 * arr[i].x + 0.28 * arr[i].y,
                        0.26 * arr[i].x + 0.24 * arr[i].y + 0.44);
            } else {
                arr[i + 1] = new Vector2f(0.2 * arr[i].x - 0.26 * arr[i].y,
                        0.23 * arr[i].x + 0.22 * arr[i].y + 1.6);
            }
        } else {
            arr[i + 1] = new Vector2f(0.85 * arr[i].x + 0.04 * arr[i].y, -0.04
                    * arr[i].x + 0.85 * arr[i].y + 1.6);
        }
    }
    return arr;
};
var index = function (row, col, cols) {
    return row * cols + col;
};
var drawBarnsley = function (steps) {
    var img1 = ctx.getImageData(0, 0, width, height);
    var idata = img1.data;
    var arr = calculateBarnsley(steps);
    for (var i = 0; i < arr.length; i++) {
        var x = cutDecimal(arr[i].x * 50) + 3 * 50;
        var y = cutDecimal(arr[i].y * 50) + 3 * 50;
        var j = 4 * index(x, y, width);
        idata[j] = 0;
        idata[j + 1] = 255;
        idata[j + 2] = 0;
        idata[j + 3] = 255;
    }
    ctx.putImageData(img1, 0, 0);
};
var srodek = function (v1, v2) {
    return new Vector2f((v1.x + v2.x) / 2, (v1.y + v2.y) / 2);
};
var randomInRange = function (min, max) {
    var random = -1;
    if (min > max) {
        return new Error('Pierwsza licba musi być mniejsza od drugiej');
    } else {
        random = cutDecimal(Math.floor(Math.random() * (max - min + 1)) + min);
    }
    return random;
};
var drawSierpinskiRandom = function (steps) {
    var A = new Vector2f(0.0, width);
    var B = new Vector2f(width, width);
    var C = new Vector2f(width / 2, width - width * Math.sqrt(3) / 2);
    var D = new Vector2f(width / 4, width - width / 16.0);
    var centrum = null;
    var img1 = ctx.getImageData(0, 0, width, height);
    var idata = img1.data;
    for (var i = 0; i < steps; i++) {
        var r = randomInRange(0, 2);
        switch (r) {
            case 0:
                centrum = srodek(D, A);
                break;
            case 1:
                centrum = srodek(D, B);
                break;
            case 2:
                centrum = srodek(D, C);
                break;
        }
        var j = 4 * index(cutDecimal(centrum.y), cutDecimal(centrum.x), width);
        idata[j] = 0;
        idata[j + 1] = 255;
        idata[j + 2] = 0;
        idata[j + 3] = 255;
        D = centrum;
    }
    ctx.putImageData(img1, 0, 0);
};
// -
function Tuple(x, y, headDir) {
    this.x = x;
    this.y = y;
    this.headDir = headDir;
}
;
function Turtle(x, y, headDir, ww, vars, start, rules, scale, steps, angle) {
    this.x = x;
    this.y = y;
    this.headDir = headDir;
    this.ww = ww;
    this.vars = vars;
    this.start = start;
    this.rules = rules;
    this.scale = scale;
    this.steps = steps;
    this.distance = this.getDistance(steps, scale);
    this.frules = this.process(steps, start, rules, vars);
    this.angle = angle;
    this.memo = new Array();
}
;
Turtle.prototype.tailDown = function (x, y) {
    ctx.beginPath();
    ctx.strokeStyle = "black";
    ctx.lineWidth = 1;
    ctx.moveTo(Math.floor(this.x), Math.floor(this.y));
    ctx.lineTo(Math.floor(this.x + x), Math.floor(this.y + y));
    ctx.stroke();

};
Turtle.prototype.move = function (distance, tailDown) {
    var x = Math.cos(this.headDir) * distance;
    var y = Math.sin(this.headDir) * distance;
    if (tailDown) {
        this.tailDown(x, y);
    }
    this.x += x;
    this.y += y;
};
Turtle.prototype.process = function (steps, start, rules, vars) {
    var result = start;
    var result1 = "";
    for (var i = 0; i < steps; i++) {
        for (var j = 0; j < result.length; j++) {
            var temp = result.substring(j, j + 1);
            for (var k = 0; k < vars.length; k++) {
                if (temp === vars[k]) {
                    result1 = result1.concat(rules[k]);
                }
            }
        }
        result = result1;
        result1 = "";
    }
    return result;
};
Turtle.prototype.getDistance = function (steps, scale) {
    var wt1 = this.ww;
    for (var i = 0; i < steps; i++) {
        wt1 *= scale;
    }
    return wt1;
};
Turtle.prototype.draw = function () {
    var a = "";
    for (var i = 0; i < this.frules.length; i++) {
        a = this.frules.substring(i, i + 1);
        switch (a) {
            case "F":
            case "G":
                this.move(this.distance, true);
                break;
            case "X":
            case "Y":
            case "Z":
                break;
            case "f":
                this.move(this.distance, false);
                break;
            case "+":
                this.headDir += this.angle;
                break;
            case "-":
                this.headDir -= this.angle;
                break;
            case "[":
                var t = new Tuple(this.x, this.y, this.headDir);
                this.memo.push(t);
                break;
            case "]":
                var t = this.memo.pop();
                this.x = t.x;
                this.y = t.y;
                this.headDir = t.headDir;
                break;
        }
    }
};
// gridSize = 2 oznacza siatke, 2 x 2
// gridSize 4 oznacza siatke 4 x 4, etc.
var countCells = function (gridSize) {
    var canvasWidth = width;
    var cellWidth = canvasWidth / gridSize;
    var img1 = ctx.getImageData(0, 0, width, height);
    var idata = img1.data;
    var sum = 0;
    for (var i = 0; i < canvasWidth; i += cellWidth) {
        for (var j = 0; j < canvasWidth; j += cellWidth) {
            br: for (var k = i; k < i + cellWidth; k++) {
                for (var m = j; m < j + cellWidth; m++) {
                    var n = 4 * index(k, m, width);
                    if ((idata[n] < 200) || (idata[n + 1] < 200)
                            || (idata[n + 2] < 200)) {
                        sum++;
                        break br;
                    }
                }
            }
        }
    }
    ctx.fillText(sum, 20, 20);
    return sum;
};
var solve = function (arr1, arr2) {
    var matrix1 = new Matrix(arr1);
    var matrix2 = new Matrix(arr2);
    var matrix3 = matrix1.reverte();
    var matrix4 = matrix3.multiply2(matrix2);
    return [matrix4.getMN(0, 0), matrix4.getMN(1, 0)];
};
var drawAtractorLorenza = function () {
    var x0 = (Math.random() * 48.0 - 24.0) / 2.0;
    var y0 = (Math.random() * 48.0 - 24.0) / 2.0;
    var z0 = Math.random() * 24.0 / 2.0;
    var ro = 10.0;
    var r = 28.0;
    var b = 8.0 / 3.0;
    var h = 0.01;
    ctx.save();
    ctx.strokeStyle = "blue";
    for (var i = 0; i < 8000; i++) {
        var x = x0 * 10 + 410;
        var y = y0 * 10 + 410;
        ctx.moveTo(x, y);
        ctx.arc(x, y, 1, 0, 2 * Math.PI, true);
        var x1 = x0 + h * ro * (y0 - x0);
        var y1 = y0 + h * (x0 * (r - z0) - y0);
        var z1 = z0 + h * (x0 * y0 - b * z0);
        x0 = x1;
        y0 = y1;
        z0 = z1;
    }
    ctx.stroke();
    ctx.restore();
};
