//rożnica między wartością maksymalną a minimalną
var r = function (max, min) {
    return max - min;
};
var log10 = function (x) {
    return Math.LOG10E * Math.log(x);
};
// liczba przedziałów klasowych
var k = function (n) {
    return Math.floor(1 + 3.3 * log10(n));
};
// długość przedziałów klasowych
var c = function (r, k) {
    return roundToDecimal(r / k, 1);
};
var roundToDecimal = function (num, dec) {
    var multi = Math.pow(10, dec);
    return Math.round(num * multi) / multi;
};
var numsort = function (a, b) {
    return a - b;
};
var klasy = function (array) {
    array.sort(numsort);
    var len = array.length;// długość
    var max = array[len - 1];// maksimum
    var min = array[0];// minimum
    var ra = r(max, min);// rozstęp
    var ka = k(len);// liczba przedziałów klasowych
    var ca = c(ra, ka);// długość przedziału klasowego
    var farray = new FrequencyArray();
    for (var i = 0; i < len; i++) {
        for (var j = 0; j < ka; j++) {
            var a = roundToDecimal(min + ca * j, 1);
            var b = roundToDecimal((min + ca) + ca * j, 1);
            if (array[i] >= a && array[i] < b) {               
                farray.add(roundToDecimal(a + 0.5 * (b - a), 1));
                break;
            }
        }
    }
    var vects = farray.getAllAsVectors2();
    vects = vects.sort();
    return vects;
};
var cutDecimal = function (nr) {
    var temp = nr.toString();
    var temp1 = temp.indexOf(".");
    var temp2 = "";
    if (temp1 > -1) {
        temp2 = temp.substr(0, temp1);
    } else {
        temp2 = temp;
    }
    return parseInt(temp2);
};
/**
 * Funkcja zaokrągla liczby 2, 5, 10 etc, do najbliższej wielokrotności
 * całkowitej tej liczby np roundTo(92.5, 5) zaokrągla do 95, roundTo(92.5, 10)
 * do 90, etc.
 * 
 * @param num
 *            double - liczba do zaokrąglenia
 * @param round
 *            int - rzad wielkości do zaokrąglenia
 * @return zwraca przetworzoną liczbę
 */
var roundToMulti = function (num, round) {
    var num1 = num;
    var round1 = round;
    return cutDecimal(Math.round(num1 / round1) * round1);
};
// podajemy tablicę wyników array
// szerokość wykresu width w pikselach np. 200
// nazwę dla osi X
// nazwę dla osi Y
// wielkość przerwy między słupkami w px
// fillstyle;
var Histogram = function (array, width, nameX, nameY, gapWidth, fillStyle) {
    var cv = document.getElementById('canvas');
    var ctx = cv.getContext('2d');
    ctx.save();
    ctx.beginPath();
    var dist = width * 0.06;// odległość osi od brzegów wykresu
    var maxY = 0;// najwyższa wartość na osi Y
    var minY = Number.MAX_VALUE;// najniższa wartość na osi Y
    var kl = klasy(array);
    var len = kl.length;
    for (var i = 0; i < len; i++) {
        maxY = Math.max(maxY, kl[i].y);
        minY = Math.min(minY, kl[i].y);
    }
    var minX = Number.MAX_VALUE;
    for (var ii = 0; ii < len; ii++) {
        minX = Math.min(minX, kl[ii].x);
    }
    var h = roundToMulti(width / 1.618, 10);
    var osYLen = h - 2 * dist;
    var itemY = cutDecimal((osYLen - 0.25 * dist) / maxY);// ile pikseli
    // zajmuje jednostka    
    var osXLen = width - 2 * dist;// długość osi X = 180
    var diagW = osXLen - dist;// szerokość wykresu na osi X =170
    var barW = cutDecimal(diagW / len);
    drawArrow(dist, h - dist, osXLen, 0.5, 0, 12, 10, true, "black");// oś X
    drawArrow(dist, h - dist, osYLen, 0.5, 90, 12, 10, true, "black");// oś Y
    ctx.fillStyle = fillStyle;
    ctx.strokeStyle = "black";
    // -
    for (var j = 0; j < len; j++) {// rozrysowanie słupków
        ctx.strokeRect(dist + j * barW + gapWidth / 2, h - dist
                - kl[j].y * itemY, barW - gapWidth, (kl[j].y)
                * itemY);
        ctx.fillRect(dist + j * barW + gapWidth / 2, h - dist
                - kl[j].y * itemY, barW - gapWidth, (kl[j].y)
                * itemY);
    }
    var x = maxY - minY;
    var y = x.toString();
    var z = y.length;
    var zz = 0;
    switch (z) {
        case 1:
            zz = 1;
            break;
        case 2:
            zz = 10;
            break;
        case 3:
            zz = 100;
            break;
        case 4:
            zz = 1000;
            break;
    }
    var fs = 0.02 * width + 3;
    ctx.font = fs + "px sans-serif";
    for (var k = 1; k < cutDecimal(maxY / zz) + 1; k++) {
        ctx.moveTo(dist - 5, h - dist - zz * itemY * k);
        var zzz = (zz * k).toString();
        ctx.textBaseline = "middle";
        ctx.textAlign = "center";
        ctx.fillText(zzz, dist - ctx.measureText(zzz).width, h - dist - zz
                * itemY * k);
        ctx.lineTo(dist, h - dist - zz * itemY * k);
    }
    for (var m = 0; m < len; m++) {
        ctx.fillText(kl[m].x, dist + m * barW + barW / 2, h
                - dist + 0.5 * dist);
    }
    ctx.textAlign = "left";
    ctx.fillText(nameY, dist - 0.5 * dist, dist - 0.5 * dist);
    ctx.fillText(nameX, 2 * dist + osXLen - ctx.measureText(nameX).width, h
            - dist + 0.5 * dist);
    ctx.fill();
    ctx.stroke();
    ctx.restore();
    return null;
};
/**
 * Podaje losową liczbę z przedziału zamkniętego <min, max>
 *  * @param min int - najmniejsza wartość
 * @param max int - największa wartość
 * @return int - wylosowana wartość z podanego zakresu, z uwzględniem min i max
 */
var randomInRange = function (min, max) {
    var random = -1;
    if (min > max) {
        throw new Error("pierwsza liczba musi być mniejsza od drugiej");
    } else {
        random = cutDecimal(Math.floor(Math.random() * (max - min + 1)) + min);
    }
    return random;
};

/**
 * Zwraca tablicę k liczb wybraych losowo z tablicy od 1 do n liczb bez
 * zwracania (powtórzeń)
 *  * @param k liczba wybieranych liczb
 * @param n największa liczba
 * @param sorted  określa czy wyjściowa tablica liczb będzie posortowana czy nie,
 *            <code>true</code> oznacza tablicę posortowaną,
 *            <code>false</code> oznacza tablicę nie sortowaną
 * @return [] - tablica wybranych liczb
 */
var withoutReturn = function (k, n, sorted) {
    var wynik = new Array(k);
    if (k > n) {
        throw new Error("pierwsza liczba nie możę być większa od drugiej");
    } else {
        var liczby = new Array(n);
        for (var j = 0; j < liczby.length; j++) {
            liczby[j] = j + 1;
        }
        for (var i = 0; i < wynik.length; i++) {
            var l = cutDecimal(Math.floor(Math.random() * n));
            wynik[i] = liczby[l];
            liczby[l] = liczby[n - 1];
            n--;
        }
        if (sorted) {
            wynik = wynik.sort(numsort);
        }
    }
    return wynik;
};
var degToRad = function (deg) {
    return Math.PI * deg / 180.0;
};

/**
 * Skaluje tablicę double[] na tablicę kątów (w stopniach). 
 * @param {type} data - tablica doubli
 * @returns {Array} - zwraca talicę katów rzutowaną na 360 stopni
 */
var dataToAngle = function (data) {
    var len = data.length;
    var temp = new Array(len);
    var sum = 0;
    for (var i = 0; i < len; i++) {
        sum += data[i];
    }
    for (var j = 0; j < len; j++) {
        temp[j] = (data[j] * 360.0) / sum;
    }
    return temp;
};
// podajemy promień, tabele z danymi i tabele
// z opisami
var drawApplePie = function (radius, data, labels) {
    var cv = document.getElementById('canvas');
    var ctx = cv.getContext('2d');
    var len = data.length;
    var len1 = labels.length;
    if (len !== len1) {
        throw new Error("długości tablic muszą być równe");
    }
    for (var i = 0; i < data.length; i++) {
        if (data[i] < 0) {
            throw new Error("liczby nie mogą być ujemne");
        }
    }
    var colors = new Array("#FF0000", "#00FF00", "#00FFFF",
            "#FF00FF", "#404040", "#FFC800", "#FF0000",
            "#C0C0C0", "#FFAFAF", "#FFFF00");
    var colors2 = withoutReturn(len, colors.length, false);
    var x = radius * 0.1;
    var y = radius * 0.1;
    var xx = x + radius;
    var yy = y + radius;
    var angles = dataToAngle(data);
    var kat = 0.0;
    var katS = 0.0;// kąt dla napisu
    var xxx = radius * 0.1;
    var yyy = radius * 0.1;
    var ww = radius * 0.1;
    var hh = radius * 0.1;
    ctx.save();
    var fs = cutDecimal(6 + 0.04 * radius);
    ctx.font = fs.toString() + "px sans-serif";
    for (var i = 0; i < len; i++) {
        ctx.beginPath();
        ctx.fillStyle = colors[colors2[i] - 1];
        ctx.fillRect(x + 2 * radius + xxx, yyy, ww, hh);
        ctx.moveTo(xx, yy);
        ctx.arc(xx, yy, radius, degToRad(kat), degToRad(kat)
                + degToRad(angles[i]), false);
        kat += angles[i];
        ctx.fill();
        ctx.beginPath();
        katS = kat - angles[i] / 2;
        var xxS = xx + (radius * 0.7 * Math.cos(degToRad(katS)));
        var yyS = yy + (radius * 0.7 * Math.sin(degToRad(katS)));
        ctx.fillStyle = "black";
        ctx.textAlign = "center";
        ctx.textBaseline = "alphabetic";
        ctx.fillText(data[i].toString(), xxS, yyS);
        ctx.textAlign = "start";
        ctx.textBaseline = "bottom";
        ctx.fillText(labels[i] + " " + data[i] + "%", 
                x + 2 * radius + xxx + 30, yyy + radius * 0.1);
        yyy += radius * 0.2;
        ctx.fill();
    }
    ctx.restore();

};
var Liniowy = function (array, szer, nazwaX, nazwaY, fillStyle) {
    var cv = document.getElementById('canvas');
    var ctx = cv.getContext('2d');
    ctx.save();
    ctx.beginPath();
    var dist = szer * 0.06;// odległość osi od brzegów wykresu
    var maxY = 0;// najwyższa wartość na osi Y
    var minY = Number.MAX_VALUE;// najniższa wartość na osi Y
    var klas = klasy(array);
    var len = klas.length;
    for (var i = 0; i < len; i++) {
        maxY = Math.max(maxY, klas[i].y);// 41
        minY = Math.min(minY, klas[i].y);// 1
    }
    var minX = Number.MAX_VALUE;
    for (var ii = 0; ii < len; ii++) {
        minX = Math.min(minX, klas[ii].x);
    }
    var wys = roundToMulti(szer / 1.618, 10);// wysokość wykresu 120
    var osYLen = wys - 2 * dist;// długość osi Y = 100
    var jednY = cutDecimal((osYLen - 0.25 * dist) / maxY);// ile pikseli
    // zajmuje jednostka na osi Y = 2
    var osXLen = szer - 2 * dist;// długość osi X = 180
    var szerWykr = osXLen - dist;// szerokość wykresu na osi X =170
    var szerSlupka = cutDecimal(szerWykr / len);// 170/8=21 pikseli
    drawArrow(dist, wys - dist, osXLen, 0.5, 0, 12, 10, true, "black");// oś X
    drawArrow(dist, wys - dist, osYLen, 0.5, 90, 12, 10, true, "black");// oś Y
    // -
    ctx.strokeStyle = fillStyle;
    ctx.fillStyle = fillStyle;
    for (var j = 0; j < len - 1; j++) {// rozrysowanie słupków
        var x1 = dist + j * szerSlupka + szerSlupka / 2;
        var y1 = wys - dist - klas[j].y * jednY;
        ctx.moveTo(x1, y1);
        // ctx.arc(x1,y1,1,0,2*Math.PI, false);
        x2 = dist + (j + 1) * szerSlupka + szerSlupka / 2;
        y2 = wys - dist - klas[j + 1].y * jednY;
        ctx.lineTo(x2, y2);
    }
    var x = maxY - minY;
    var y = x.toString();
    var z = y.length;
    var zz = 0;
    switch (z) {
        case 1:
            zz = 1;
            break;
        case 2:
            zz = 10;
            break;
        case 3:
            zz = 100;
            break;
        case 4:
            zz = 1000;
            break;
    }
    var fs = 0.02 * szer + 3;
    ctx.font = fs + "px sans-serif";
    for (var k = 1; k < cutDecimal(maxY / zz) + 1; k++) {
        ctx.moveTo(dist - 5, wys - dist - zz * jednY * k);
        var zzz = (zz * k).toString();
        ctx.textBaseline = "middle";
        ctx.textAlign = "center";
        ctx.fillText(zzz, dist - ctx.measureText(zzz).width, wys - dist - zz
                * jednY * k);
        ctx.lineTo(dist, wys - dist - zz * jednY * k);
    }
    for (var m = 0; m < len; m++) {
        ctx.fillText(klas[m].x, dist + m * szerSlupka + szerSlupka / 2, wys
                - dist + 0.5 * dist);
    }
    ctx.textAlign = "left";
    ctx.fillText(nazwaY, dist - 0.5 * dist, dist - 0.5 * dist);
    ctx.fillText(nazwaX, 2 * dist + osXLen - ctx.measureText(nazwaX).width, wys
            - dist + 0.5 * dist);
    ctx.fill();
    ctx.stroke();
    ctx.restore();
    return null;
};
// oblicza średnią arytmetyczną szeregu
var mean = function (array) {
    return sum(array) / array.length;
};
// dominanta
// trzeba podać dokladność (liczbę miejsc po przecinku) doubli
var mode = function (array) {
    array.sort(numsort);
    var freq = new FrequencyArray();
    for (var i = 0; i < array.length; i++) {
        freq.add(array[i]);
    }
    var values = freq.getAllAsVectors();
    var max = 0;
    var dom = new Array();
    for (var j = 0; j < values.length; j++) {
        max = Math.max(max, values[j].y);
    }
    for (var k = 0; k < values.length; k++) {
        if (values[k].y === max) {
            dom.push(values[k].x);
        }
    }

    return dom;
};
// oblicza maksimum
var max = function (array) {
    array.sort(numsort);
    return array[array.length - 1];
};
// oblicza wartość minimalną
var min = function (array) {
    array.sort(numsort);
    return array[0];
};
var gap = function (array) {
    return max(array) - min(array);
};
var sum = function (array) {
    var suma = 0;
    for (var i = 0; i < array.length; i++) {
        suma += array[i];
    }
    return suma;
};
// logarytm naturalny z b
var ln = function (b) {
    return Math.log(b);
};
// logarytm dziesiętny z b
var lg = function (b) {
    return Math.LOG10E * Math.log(b);
};
// logarytm o dowolnej podstawie także o podstawie 10 lub e
var log = function (b, a) {
    return Math.log(b) / Math.log(a);
};
// oblicza percentyl
var percentyl = function (perc, arr) {
    arr.sort(numsort);
    var ind = (arr.length + 1) * perc / 100;
    var ind1 = cutDecimal(ind);
    var w1 = arr[ind1 - 1];
    var ind2 = ind - ind1;
    var w2 = arr[ind1];
    var dist = w1 + (w2 - w1) * ind2;
    return roundToDecimal(dist, 2);
};
// rozstęp - rożnica między maksymalną i minimalną wartością w tablicy
// odstęp międzykwartylowy
var in_quart_dist = function (array) {
    array.sort(numsort);
    var perc1 = percentyl(75, array);
    var perc2 = percentyl(25, array);
    return (perc1 - perc2);
};

// oblicza medianę
var median = function (array) {
    return percentyl(50, array);
};
var var_pop = function (array) {
    var sum = 0;
    var sumk = 0;
    var len = array.length;
    for (var i = 0; i < len; i++) {
        sum += array[i];
        sumk += Math.pow(array[i], 2);
    }
    return (len * sumk - Math.pow(sum, 2)) / (len * len);
};
var sd_pop = function (array) {
    return Math.sqrt(var_pop(array));
};
var var_sample = function (array) {
    var sum = 0;
    var sumk = 0;
    var len = array.length;
    for (var i = 0; i < len; i++) {
        sum += array[i];
        sumk += Math.pow(array[i], 2);
    }
    return (len * sumk - Math.pow(sum, 2)) / (len * (len - 1));
    return sumk;
};
var sd_sample = function (array) {
    return Math.sqrt(var_sample(array));
};
var cv_sample = function (array) {
    return sd_sample(array) / mean(array);
};
var m1 = function (array) {
    return 0;
};
var m2 = function (array) {
    return var_sample(array);
};
var m3 = function (array) {
    var sum = 0;
    var me = mean(array);
    for (var i = 0; i < array.length; i++) {
        sum += Math.pow(array[i] - me, 3);
    }
    return sum / array.length;
};
var g1 = function (array) {
    return m3(array) / Math.pow(sd_sample(array), 3);
};
var m4 = function (array) {
    var sum = 0;
    var me = mean(array);
    for (var i = 0; i < array.length; i++) {
        sum += Math.pow(array[i] - me, 4);
    }
    return sum / array.length;
};
var g2 = function (array) {
    return (m4(array) / Math.pow(var_sample(array), 2)) - 3;
};