var cv = document.getElementById('canvas');
var ctx = cv.getContext('2d');
var width = cv.width;
var height = cv.height;
var liczbaPol = 100;
var szer = 8;// odleglosc miedzy liniami = szerokosc komorki
var len = szer * liczbaPol;
var len1 = len / 2;
var timer = null;
// tworzy automat o danym numerze zaczynajacy sie od wybranej kombinacji
// startowej
function Automaton(autoNumber, kombStart, ksztaltKomorek, kolorKomorek) {
	this.autoNumber = autoNumber;
	this.kombStart = kombStart;
	this.ksztaltKomorek = ksztaltKomorek;
	this.kolorKomorek = kolorKomorek;
	this.autos = new Array(liczbaPol*2);
	for ( var i = 0; i < liczbaPol *2; i++) {
		this.autos[i] = new Array(liczbaPol*2);
	}
	for ( var k = 0; k < liczbaPol* 2; k++) {
		for ( var j = 0; j < liczbaPol * 2; j++)
			this.autos[k][j] = 0;
	}
	var startCell = liczbaPol;
	this.autos[0][startCell - 1] = kombStart[0];
	this.autos[0][startCell] = kombStart[1];
	this.autos[0][startCell + 1] = kombStart[2];
	for ( var m = 1; m < liczbaPol * 2 - 1; m++) {
		for ( var n = 1; n < liczbaPol * 2 - 1; n++) {
			var arr = new Array(3);
			arr[0] = this.autos[m - 1][n - 1];
			arr[1] = this.autos[m - 1][n];
			arr[2] = this.autos[m - 1][n + 1];
			this.autos[m][n] = nextValue(arr, autoNumber);
		}
	}
};

var drawAutomaton = function(automaton) {
	ctx.save();
	ctx.beginPath();
	ctx.strokeStyle = "rgb(220,220,220)";
	var z = 0;// polozenie linii
	for ( var i = 0; i <= liczbaPol / 2; i++) {
		ctx.moveTo(0, z);
		ctx.lineTo(len, z);
		z += szer;
	}
	z = 0;
	for ( var k = 0; k <= liczbaPol; k++) {
		ctx.moveTo(z, 0);
		ctx.lineTo(z, len1);
		z += szer;
	}
	ctx.stroke();
	ctx.restore();
	ctx.save();
	ctx.beginPath();
	ctx.fillStyle = automaton.kolorKomorek;
	for ( var m = 0; m < liczbaPol ; m++) {
		for ( var j = liczbaPol / 2; j < liczbaPol + liczbaPol / 2; j++) {
			if (automaton.autos[m][j] === 1) {
				var y = m * szer;
				var x = (j - liczbaPol / 2) * szer;
				switch (automaton.ksztaltKomorek) {
				case "KOLO":
                                        ctx.beginPath();                                      
					ctx.arc(x + szer / 2, y + szer / 2, szer / 2, 0, Math.PI * 2, false);                                                                                                                                                  
                                        ctx.fill();
                                        ctx.save();
					break;
				case "KWADRAT":
					ctx.fillRect(x, y, szer, szer);
				}
			}
		}
	}
	//ctx.fill();
	ctx.restore();

};

var order = function(array) {
	var val = 0;
	var len = array.length;
	for ( var i = 0; i < len; i++) {
		if (array[len - 1 - i] === 1) {
			val += cutDecimal(Math.pow(2, i));
		}
	}
	return val;
};
var nextValue = function(array, automatNumber) {
	var val = order(array);
	var nbin = parseInt(automatNumber).toString(2);
	if (nbin.length < 8) {
		var diff = 8 - nbin.length;
		for ( var i = 0; i < diff; i++) {
			nbin = "0".concat(nbin);
		}
	}
	var len = nbin.length;
	var sval = nbin.substring(len - val - 1, len - val);
	return parseInt(sval);
};
var cutDecimal = function(nr) {
	var temp = nr.toString();
	var temp1 = temp.indexOf(".");
	var temp2 = "";
	if (temp1 > -1) {
		temp2 = temp.substr(0, temp1);
	} else {
		temp2 = temp;
	}
	return parseInt(temp2);
};
function Life(ksztaltKomorek, kolorKomorek, probability) {
	this.ksztaltKomorek = ksztaltKomorek;
	this.kolorKomorek = kolorKomorek;
	this.probability = probability;
	this.autos1 = new Array(liczbaPol);
	this.autos2 = new Array(liczbaPol);
	for ( var i = 0; i < liczbaPol; i++) {
		this.autos1[i] = new Array(liczbaPol);
		this.autos2[i] = new Array(liczbaPol);
	}
	for ( var j = 0; j < liczbaPol; j++) {
		for ( var k = 0; k < liczbaPol; k++) {
			this.autos1[j][k] = Math.random() < this.probability;
			this.autos2[j][k] = false;
		}
	}
}
Life.prototype.actualize = function() {
	var cells = this.autos1;
	for ( var i = 0; i < liczbaPol; i++) {
		for ( var j = 0; j < liczbaPol; j++) {
			this.autos2[i][j] = cells[i][j];
			var nb = this.liczbaSasiadow(cells, i, j);
			if (nb === 3)
				this.autos2[i][j] = true;
			if (nb < 2 || nb > 3)
				this.autos2[i][j] = false;
		}
	}
	this.autos1 = this.autos2;
	this.autos2 = cells;
};
// oblicza liczbe sasiadow komorki
// p i q sa indeksami okreslajacymi polozenie komorki
// autos[][] jest tablicą komórek
Life.prototype.liczbaSasiadow = function(autos, p, q) {
	var x1 = p;
	var x2 = p;
	var y1 = q;
	var y2 = q;
	var licznik = 0;
	if (p > 0) {
		x1--;
	}
	if (p < liczbaPol - 1) {
		x2++;
	}
	if (q > 0) {
		y1--;
	}
	if (q < liczbaPol - 1) {
		y2++;
	}
	for ( var i = x1; i <= x2; i++) {
		for ( var j = y1; j <= y2; j++) {
			licznik += (autos[i][j]) ? 1 : 0;
		}
	}
	if (autos[p][q]) {
		licznik--;
	}
	return licznik;
};
Life.prototype.drawLife = function() {
	this.actualize();
	ctx.save();
	ctx.clearRect(0, 0, 800, 800);
	ctx.beginPath();
	ctx.strokeStyle = "rgb(220,220,220)";
	var z = 0;// polozenie linii
	for ( var i = 0; i <= liczbaPol; i++) {
		ctx.moveTo(0, z);
		ctx.lineTo(len, z);
		ctx.moveTo(z, 0);
		ctx.lineTo(z, len);
		z += szer;
	}
	ctx.stroke();
	ctx.beginPath();
	ctx.fillStyle = this.kolorKomorek;
	for ( var m = 0; m < liczbaPol; m++) {
		for ( var j = 0; j < liczbaPol; j++) {
			if (this.autos1[m][j]) {
				var y = m * szer;
				var x = j * szer;
				switch (this.ksztaltKomorek) {
				case "KOLO":
                                        ctx.beginPath();
					ctx.arc(x + szer / 2, y + szer / 2, (szer / 2) - 1, 0,
							Math.PI * 2, false);
                                        ctx.fill();
                                        ctx.save();
					break;
				case "KWADRAT":
					ctx.fillRect(x, y, szer, szer);
					break;
				}
			}
		}

	}
	//ctx.fill();
	ctx.restore();
};
Life.prototype.clear = function() {
	for ( var j = 0; j < liczbaPol; j++) {
		for ( var k = 0; k < liczbaPol; k++) {
			this.autos1[j][k] = false;
			this.autos2[j][k] = false;
		}
	}
};
Life.prototype.putStructure = function(array, cols) {
	this.clear();
	var arr = oneToTwo(array, cols);
	for ( var m1 = 0; m1 < arr.length; m1++) {
		for ( var j1 = 0; j1 < arr[0].length; j1++) {
			this.autos1[m1 + 25][j1 + 25] = arr[m1][j1];
		}
	}
};

var oneToTwo = function(tab, cols) {
	var rows = tab.length / cols;
	var temparr = new Array(rows);
	for ( var k = 0; k < rows; k++) {
		temparr[k] = new Array(cols);
	}
	for ( var i = 0; i < tab.length; i++) {
		var x = cutDecimal(i / cols);
		var y = i % cols;
		temparr[x][y] = tab[i];
	}
	return temparr;
};
