package math.trans;

import math.axes.CartesianAxPanel;
import math.line.LineUtil;
import math.matrix.Matrix;
import math.matrix.MatrixException;
import math.shapes.Line;
import math.utils.MathUtil;

import javax.swing.*;
import java.awt.*;

public class Trans08 extends JFrame {
    private static final long serialVersionUID = 431281611636634328L;
    public static final int fw = 1000;
    public static final int fh = 1000;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Trans08(new TransPanel08()));
    }

    public Trans08(JComponent comp) {
        setLayout(null);
        setPreferredSize(new Dimension(fw, fh));
        setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fh / 2), fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        //	setResizable(false);
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}

class TransPanel08 extends CartesianAxPanel {
    private static final long serialVersionUID = 8115404932220947612L;

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        Line line = new Line(-7, -6, 7, 6);
        LineUtil.drawLine(-7, -6, 7, 6, g2, Color.GREEN);
        double slope = line.slope();
        g2.drawString("" + slope, 440, 170);
        double angle = Math.atan(slope);
        g2.drawString("" + MathUtil.radToDeg(angle), 440, 190);
        TransUtil.drawTriangle(4, 4, 5, 6, 2, 5, g2, Color.BLUE);
        double[][] pointa = {{4}, {4}, {1}};
        Matrix mata = new Matrix(pointa);
        Matrix transa = new Matrix(3, 3);
        try {
            transa.setToIdentity();
        } catch (MatrixException e) {
            e.printStackTrace();
        }
        transa.setToReflection(line);
        Matrix aa = transa.multiply2(mata);
        //-
        double[][] pointb = {{5}, {6}, {1}};
        Matrix matb = new Matrix(pointb);
        Matrix transb = new Matrix(3, 3);
        try {
            transb.setToIdentity();
        } catch (MatrixException e) {
            e.printStackTrace();
        }
        transb.setToReflection(line);
        Matrix bb = transb.multiply2(matb);
        //-
        double[][] pointc = {{2}, {5}, {1}};
        Matrix matc = new Matrix(pointc);
        Matrix transc = new Matrix(3, 3);
        try {
            transc.setToIdentity();
        } catch (MatrixException e) {
            e.printStackTrace();
        }
        transc.setToReflection(line);
        Matrix cc = transc.multiply2(matc);
        //-
        try {
            TransUtil.drawTriangle((float) aa.getCell(0, 0),
                    (float) aa.getCell(1, 0), (float) bb.getCell(0, 0),
                    (float) bb.getCell(1, 0), (float) cc.getCell(0, 0),
                    (float) cc.getCell(1, 0), g2, Color.RED);
        } catch (MatrixException e) {
            e.printStackTrace();
        }
    }
}
