package math.fractals;

import math.axes.Ax;
import math.axes.PShape;

import javax.swing.*;
import java.awt.*;

class Fractal28 extends JFrame {
    private static final long serialVersionUID = 431281611636634328L;
    public static final int fw = 1000;
    public static final int fh = 1000;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Fractal28(new AxPanel02()));
    }

    Fractal28(JComponent comp) {
        setLayout(null);
        setPreferredSize(new Dimension(fw, fh));
        setBounds(
                (Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fh / 2),
                fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        setResizable(false);
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}

class AxPanel02 extends JPanel {
    private static final long serialVersionUID = 5218506428064759030L;
    private static final int w = 860;
    private static final int h = 860;
    private static final int offset = 30;

    public AxPanel02() {
        setPreferredSize(new Dimension(w, h));
        setSize(w, h);
        setBackground(Color.WHITE);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        Ax diag1 = new Ax(0, 0, 800, 800, 0, 0, 100, 100, g2, 20, 20, offset);
        diag1.drawGrid(Color.LIGHT_GRAY);
        diag1.drawXLegend(true);
        diag1.drawYLegend(true);
        diag1.drawTitle("Równanie logistyczne dla r=0.1");
        g2.drawString("Czas (jedn)", 790, 855);
        g2.drawString("K (szt. osobn.)", 5, 12);
        float dt = 1f;
        float maxt = diag1.getRw();
        int[] Ns = {1, 1, 1, 1, 1};
        float[] Ks = {100f, 80f, 60f, 40f, 20f};
        float r = 0.1f;
        for (int a = 0; a < Ns.length; a++) {
            float N = Ns[a];
            float K = Ks[a];
            float dN = 0.0f;
            float t = 0;
            for (t = 0; t < maxt; t += dt) {
                dN = N * r * (K - N) / K;
                N += dN;
                if (N > 100) {
                    N = 100;
                }
                diag1.fillPoint(t, N, 2, PShape.Circle, Color.BLUE);
            }
        }
    }
}
