package math.entropia;

import math.utils.FrequencyMap;
import math.utils.MathUtil;

import java.util.*;

public class FermiDirac3{
	public static void main(String[] args) {
		FrequencyMap<String> map = new FrequencyMap<>();
		for(int i = 0; i < 1200000; i++){
			map.add(urna(2, 4, 2));
		}
		map.printAll();
	}

	/**
	 * 
	 * @param n - liczba kul
	 * @param k - liczba urn
	 * @param limit - ile kul mieści maksymalnie urna
	 * @return - układ urny po pojedynczym losowaniu
	 */
	public static String urna(int n, int k, int limit) {
		if(n > k){
			throw new IllegalArgumentException(
					"n musi być mniejsze lub równe k");
		}
		int[] urny = new int[k];
		for(int i = 0; i < n; i++){
			int index = MathUtil.randomInRange(1, k) - 1;
			if(urny[index] >= limit){
				i--;
			}
			else{
				urny[index]++;
			}
		}
		return Arrays.toString(urny);
	}
}
