package math.curve;

import javax.swing.*;
import java.awt.*;

public class Curve14 extends JFrame {
    /**
     *
     */
    private static final long serialVersionUID = 5533707010593453907L;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Curve14(new Hipocykloida01()));
    }

    public Curve14(JComponent comp) {
        setLayout(null);
        int fh = 1000;
        int fw = 1000;
        setPreferredSize(new Dimension(fw, fh));
        setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fw / 2), fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        //	setResizable(false);
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}

class Hipocykloida01 extends JPanel {
    private static final long serialVersionUID = -7271420472998056247L;
    private static final int w = 800;
    private static final int h = 800;

    public Hipocykloida01() {
        setPreferredSize(new Dimension(w, h));
        setSize(w, h);
        setBackground(Color.WHITE);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        CurveUtil.hipocykloida(g2, Color.BLUE, 60, 20, 1, 800);
    }
}