package math.complex;

import math.shapes.Arrow;

import javax.swing.*;
import java.awt.*;

public class ComplexAxPanel extends JPanel {
    private static final long serialVersionUID = 5218506428064759030L;
    private static final Stroke bStroke = new BasicStroke(1f,
            BasicStroke.CAP_BUTT, BasicStroke.JOIN_BEVEL);
    public static final Font font = new Font("Dialog", Font.PLAIN, 14);
    private static final Font axFont = new Font("Dialog", Font.PLAIN, 8);
    public final static float m = 30f;
    public static final int w = 800;
    public static final int h = 800;

    public ComplexAxPanel() {
        setPreferredSize(new Dimension(w, h));
        setSize(w, h);
        setBackground(Color.WHITE);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawRect(0, 0, w - 1, h - 1);
        g2.setStroke(bStroke);
        g2.setColor(Color.BLACK);
        g2.setFont(font);
        //========================== draw XY axes
        g2.drawString("X", w - 40f, ((h - 30f) / 2f) + 5f);
        g2.drawString("-X", 30f, ((h - 30f) / 2f) + 5f);
        Arrow xl = new Arrow(w / 2f, (h - 30f) / 2f, h / 2 - 50f, 1f, 180f,
                15f, 10f, true);
        g2.fill(xl);
        Arrow xr = new Arrow(w / 2f, (h - 30f) / 2f, h / 2 - 50f, 1f, 0f, 15f,
                10f, true);
        g2.fill(xr);
        g2.setColor(Color.RED);
        g2.drawString("Y", (w / 2f) - 5f, 25f);
        g2.drawString("-Y", (w / 2f) - 9, h - 45);
        Arrow yt = new Arrow(w / 2f, (h - 30f) / 2f, h / 2 - 50f, 1f, 90f, 15f,
                10f, true);
        g2.fill(yt);
        Arrow yb = new Arrow(w / 2f, (h - 30f) / 2f, h / 2 - 50f, 1f, 270f,
                15f, 10f, true);
        g2.fill(yb);
        //-------------------------- draw digits on X ax
        g2.setColor(Color.BLACK);
        g2.setFont(axFont);
        for (int i = 0; i < 11; i++) {
            g2.drawString(String.valueOf(i), w / 2f + i * m - 2f,
                    ((h - 30f) / 2f) + 12f);
        }
        for (int i = 10; i > 0; i--) {
            g2.drawString(String.valueOf(-i), 99 + (10 - i) * m,
                    ((h - 30f) / 2f) + 12f);
        }
        //------------------------- draw digits on ax Y
        g2.setColor(Color.RED);
        for (int j = 0; j < 11; j++) {
            g2.drawString(String.valueOf(j), (w / 2f) - 12, ((h - 30) / 2f) - j
                    * m + 3f);
        }
        for (int j = 10; j > 0; j--) {
            g2.drawString(String.valueOf(-j), (w / 2f) - 12, ((h - 30) / 2f)
                    + j * m);
        }
    }
}