package math.bigs;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

public class BigsUtil {
    private BigsUtil() {
    }

    public static boolean wiekszy(BigInteger f, BigInteger s) {
        return (f.compareTo(s) > 0);
    }

    public static boolean rowny(BigInteger f, BigInteger s) {
        return f.equals(s);
    }

    public static boolean mniejszy(BigInteger f, BigInteger s) {
        return (f.compareTo(s) < 0);
    }

    /**
     * Dzieli a/b.
     *
     * @param a - dzielna
     * @param b - dzielnik
     * @return BigDecimal wynik dzielenia
     */
    public static BigDecimal divide(BigInteger a, BigInteger b, int precision) {
        BigDecimal aa = new BigDecimal(a.toString());
        BigDecimal bb = new BigDecimal(b.toString());
        return aa.divide(bb, new MathContext(precision, RoundingMode.HALF_UP));
    }


    @SuppressWarnings("StringOperationCanBeSimplified")
    public static String reverteString(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder();
        for (int i = len; i > 0; i--) {
            sb.append(str.substring(i - 1, i));
        }
        return sb.toString();
    }


}

