package math.axes;

import math.shapes.Arrow;
import math.utils.Util;
import javax.swing.*;
import java.awt.*;

class JavaAxPanel extends JPanel {
    private static final long serialVersionUID = 5218506428064759030L;
    private static final Stroke B_STROKE = new BasicStroke(1f,
            BasicStroke.CAP_BUTT, BasicStroke.JOIN_BEVEL);
    private static final Font FONT = new Font("Dialog", Font.PLAIN, 14);
    private static final Font AX_FONT = new Font("Dialog", Font.PLAIN, 8);
    private final static float M = 30f;

    public JavaAxPanel() {
        setPreferredSize(new Dimension(Util.W800, Util.H800));
        setSize(Util.W800, Util.H800);
        setBackground(Color.WHITE);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawRect(0, 0, Util.W800 - 1, Util.H800 - 1);
        g2.setStroke(B_STROKE);
        g2.setColor(Color.BLACK);
        g2.setFont(FONT);
        g2.drawString("X", Util.W800 - 12, 15);
        g2.drawString("Y", 15, Util.H800 - 12);
        g2.setFont(AX_FONT);
        for (int i = 0; i < 24; i++) {
            g2.drawString("" + i, 15 + i * M, 8);
        }
        for (int j = 23; j > 0; j--) {
            g2.drawString("" + j, 5, 15 + j * M);
        }
        Arrow x = new Arrow(15, 15, Util.W800 - 40, 1f, 0, 15f, 10f, true);
        g2.draw(x);
        Arrow y = new Arrow(15, 15, Util.W800 - 40, 1f, 270, 15f, 10f, true);
        g2.draw(y);
    }
}