package math.matrix;

import math.axes.CartesianAxPanel;
import math.linear.LinearUtil;
import math.linear.Vector2;

import javax.swing.*;
import java.awt.*;

public class Matrix17 extends JFrame {
    private static final long serialVersionUID = 431281611636634328L;
    public static final int fw = 1000;
    public static final int fh = 1000;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Matrix17(new VectorPanel17()));
    }

    public Matrix17(JComponent comp) {
        setLayout(null);
        setPreferredSize(new Dimension(fw, fh));
        setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fh / 2), fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        //	setResizable(false);
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}

class VectorPanel17 extends CartesianAxPanel {
    private static final long serialVersionUID = 8115404932220947612L;

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        Vector2 vector1 = new Vector2(1.0, -1.0);
        LinearUtil.drawVector(vector1, g2, Color.BLUE);
        Vector2 vector2 = new Vector2(3.0, 4.0);
        LinearUtil.drawVector(vector2, g2, Color.BLUE);
        Vector2 vector3 = new Vector2(-2.0, 5.0);
        LinearUtil.drawVector(vector3, g2, Color.BLUE);
        Vector2 xx = new Vector2(vector1.getX() - vector2.getX(),
                vector1.getY() - vector2.getY());
        double x = xx.getLength();
        //g2.drawString("" + x, 440, 180);
        Vector2 yy = new Vector2(vector2.getX() - vector3.getX(),
                vector2.getY() - vector3.getY());
        double y = yy.getLength();
        //g2.drawString("" + y, 440, 200);
        Vector2 zz = new Vector2(vector3.getX() - vector1.getX(),
                vector3.getY() - vector1.getY());
        double z = zz.getLength();
        //g2.drawString("" + z, 440, 220);
        double p = (x + y + z) / 2;
        //g2.drawString("" + p + " ", 440, 240);
        double s = Math.sqrt(p * (p - x) * (p - y) * (p - z));
        g2.drawString("" + s + " ", 440, 260);
    }
}
