package math.line;

import math.axes.CartesianAxPanel;
import math.shapes.Line;

import javax.swing.*;
import java.awt.*;

public class Line09 extends JFrame {
    private static final long serialVersionUID = 431281611636634328L;
    public static final int fw = 1000;
    public static final int fh = 1000;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Line09(new LinePanel09()));
    }

    public Line09(JComponent comp) {
        setLayout(null);
        setPreferredSize(new Dimension(fw, fh));
        setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fh / 2), fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        //	setResizable(false);
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}

class LinePanel09 extends CartesianAxPanel {
    private static final long serialVersionUID = 8115404932220947612L;

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        Line line = LineUtil.findLine(-1.5f, 1f, -1f);
        g2.drawString("line: " + line.toString(), 470, 280);
        g2.drawString("slope: " + line.slope(), 470, 300);
        LineUtil.drawLine(line, g2, Color.BLACK, 50);
        Line line1 = LineUtil.findLine(1f, 1.5f, 2f);
        g2.drawString("line: " + line1.toString(), 470, 320);
        g2.drawString("slope: " + line1.slope(), 470, 340);
        LineUtil.drawLine(line1, g2, Color.BLACK, 50);
        g2.drawString("są prostopadłe?: " + LineUtil.areNormal(line, line1),
                470, 360);
    }
}
