package math.games;

public class Cell {
    private int row;
    private int col;
    private double value;

    public Cell() {
        this(0, 0, 0);
    }

    public Cell(int row, int col, double value) {
        this.row = row;
        this.col = col;
        this.value = value;
    }

    @Override
    public String toString() {
        return "[" + row + ", " + col + ", " + value + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        if (!(obj instanceof Cell)) {
            return false;
        }
        Cell t2 = (Cell) obj;
        return (row == t2.getRow())
                && (col == t2.getCol() && (value == t2.getValue()));
    }

    @Override
    public int hashCode() {
        return 17 * Integer.valueOf(row).hashCode() + 19
                * Integer.valueOf(col).hashCode() * 23
                * Double.valueOf(value).hashCode();
    }

    public double getRow() {
        return row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public double getCol() {
        return col;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public double getValue() {
        return value;
    }

    public void setValue(double value) {
        this.value = value;
    }
}
