package math.utils;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.*;
import java.nio.channels.FileChannel;

public class IOUtil {
    private IOUtil() {
    }

    public static void close(FileChannel channel) {
        if (channel != null) {
            try {
                channel.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(RandomAccessFile raf) {
        if (raf != null) {
            try {
                raf.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * Wczytuje obrazek z pliku i zamienia go na BufferedImage
     * Ta metoda, z nieznanych mi przyczyn nie chciała działać z filtrami
     * <code>RescaleOp</code> i <code>ConvolveOp</code>, czyli np. blur(),
     * sharp(), brightness()
     *
     * @param plik String - wskazuje plik z obrazkiem
     * @return BufferedImage - zwraca obrazek buforowany znajdujący się w pliku
     */
    public static BufferedImage fileToBimage(String plik) {
        File f = new File(plik);
        BufferedImage bimage = null;
        try {
            bimage = ImageIO.read(f);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return bimage;
    }

    public static String readFile(String file) {
        StringBuilder buf = new StringBuilder();
        BufferedReader we = null;
        try {
            we = new BufferedReader(new FileReader(file));
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        String linia;
        try {
            while ((linia = we.readLine()) != null) {
                buf.append(linia);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        try {
            we.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    public static void writeFile(String wiad, String plik) {
        File file = new File(plik);
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(file));
        } catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            bw.write(wiad);
            bw.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
