package math.trans;

import math.axes.CartesianAxPanel;
import math.line.LineUtil;
import math.matrix.Matrix;
import math.matrix.MatrixException;
import math.shapes.Line;
import math.utils.Tuple2d;

import javax.swing.*;
import java.awt.*;

public class Trans14 extends JFrame {
    private static final long serialVersionUID = 431281611636634328L;
    public static final int fw = 1000;
    public static final int fh = 1000;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Trans14(new TransPanel14()));
    }

    public Trans14(JComponent comp) {
        setLayout(null);
        setPreferredSize(new Dimension(fw, fh));
        setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fh / 2), fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        //	setResizable(false);
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}

class TransPanel14 extends CartesianAxPanel {
    private static final long serialVersionUID = 8115404932220947612L;

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        //-
        Line line = new Line(-4, -5, 7, 6);
        Line line1 = LineUtil.lineParallelThroughPoint(line, new Tuple2d(0, 0));
        LineUtil.drawLine(line, g2, Color.GREEN, 0);
        //Line line2 = LineUtil.prolongate(line1, 200);
        //LineUtil.drawLine(line2, g2, Color.MAGENTA, 0);
        double b = LineUtil.findb(line);
        TransUtil.drawTriangle(4, 4, 5, 6, 2, 5, g2, Color.BLUE);
        //-
        double[][] pointa = {{4}, {4}, {1}};
        Matrix mata = new Matrix(pointa);
        Matrix transa1 = new Matrix(3, 3);
        Matrix transa2 = new Matrix(3, 3);
        Matrix transa3 = new Matrix(3, 3);
        try {
            transa1.setToIdentity();
            transa2.setToIdentity();
            transa3.setToIdentity();
        } catch (MatrixException e) {
            e.printStackTrace();
        }
        transa1.setToTranslate(0, -b);
        Matrix aa1 = transa1.multiply2(mata);
        transa2.setToReflection(line1);
        Matrix aa2 = transa2.multiply2(aa1);
        transa3.setToTranslate(0, b);
        Matrix aa3 = transa3.multiply2(aa2);
        //-
        double[][] pointb = {{5}, {6}, {1}};
        Matrix matb = new Matrix(pointb);
        Matrix transb1 = new Matrix(3, 3);
        Matrix transb2 = new Matrix(3, 3);
        Matrix transb3 = new Matrix(3, 3);
        try {
            transb1.setToIdentity();
            transb2.setToIdentity();
            transb3.setToIdentity();
        } catch (MatrixException e) {
            e.printStackTrace();
        }
        transb1.setToTranslate(0, -b);
        Matrix bb1 = transb1.multiply2(matb);
        transb2.setToReflection(line1);
        Matrix bb2 = transb2.multiply2(bb1);
        transb3.setToTranslate(0, b);
        Matrix bb3 = transb3.multiply2(bb2);
        //-
        double[][] pointc = {{2}, {5}, {1}};
        Matrix matc = new Matrix(pointc);
        Matrix transc1 = new Matrix(3, 3);
        Matrix transc2 = new Matrix(3, 3);
        Matrix transc3 = new Matrix(3, 3);
        try {
            transc1.setToIdentity();
            transc2.setToIdentity();
            transc3.setToIdentity();
        } catch (MatrixException e) {
            e.printStackTrace();
        }
        transc1.setToTranslate(0, -b);
        Matrix cc1 = transc1.multiply2(matc);
        transc2.setToReflection(line1);
        Matrix cc2 = transc2.multiply2(cc1);
        transc3.setToTranslate(0, b);
        Matrix cc3 = transc3.multiply2(cc2);
        //-
        try {
            TransUtil.drawTriangle((float) aa2.getCell(0, 0),
                    (float) aa3.getCell(1, 0), (float) bb3.getCell(0, 0),
                    (float) bb3.getCell(1, 0), (float) cc3.getCell(0, 0),
                    (float) cc3.getCell(1, 0), g2, Color.RED);
        } catch (MatrixException e) {
            e.printStackTrace();
        }
    }
}
