package math.matrix;

import math.axes.CartesianAxPanel;
import math.linear.Vector2;

import javax.swing.*;
import java.awt.*;

public class Matrix18 extends JFrame {
    private static final long serialVersionUID = 431281611636634328L;
    public static final int fw = 1000;
    public static final int fh = 1000;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Matrix18(new VectorPanel18()));
    }

    public Matrix18(JComponent comp) {
        setLayout(null);
        setPreferredSize(new Dimension(fw, fh));
        setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fh / 2), fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        //	setResizable(false);
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}

class VectorPanel18 extends CartesianAxPanel {
    private static final long serialVersionUID = 8115404932220947612L;

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        Vector2 vector1 = new Vector2(1.0, -1.0);
        Vector2 vector2 = new Vector2(3.0, 4.0);
        Vector2 vector3 = new Vector2(-2.0, 5.0);
        Vector2 c1 = vector1.cross(vector2);
        Vector2 c2 = vector2.cross(vector3);
        Vector2 c3 = vector3.cross(vector1);
        double cl1 = c1.getLength() * 0.5;
        double cl2 = c2.getLength() * 0.5;
        double cl3 = c3.getLength() * 0.5;
        g2.drawString("cl1: " + cl1, 440, 200);
        g2.drawString("cl2: " + cl2, 440, 220);
        g2.drawString("cl3: " + cl3, 440, 240);
        double cl4 = cl1 + cl2 - cl3;
        g2.drawString("cl1+cl2-cl3: " + cl4, 440, 260);
        System.out.println("cl1: " + cl1);
        System.out.println ("cl2: " + cl2);
        System.out.println("cl3: " + cl3);
        System.out.println("cl1+cl2-cl3: " + cl4);
    }
}
