package math.logics;

public class LogicsUtil {
    private LogicsUtil() {
    }

    @SuppressWarnings("SameReturnValue")
    public static boolean verum(boolean p) {
        return true;
    }

    @SuppressWarnings("SameReturnValue")
    public static boolean falsum(boolean p) {
        return false;
    }

    public static boolean assertum(boolean p) {
        return p;
    }

    public static boolean XOR(boolean p, boolean q) {
        return (p || q) && !(p && q);
    }

    public static boolean NXOR(boolean p, boolean q) {
        return !((p || q) && !(p && q));
    }

    public static boolean NAND(boolean p, boolean q) {
        return !(p && q);
    }

    public static boolean NOR(boolean p, boolean q) {
        return !(p || q);
    }

    public static boolean IMP(boolean p, boolean q) {
        return !p || q;
    }

    public static boolean IMPR(boolean p, boolean q) {
        return p || !q;
    }

    /**
     * Aktywacja
     * @param t1 - wartosc parametru w czasie t1
     * @param t2 - wartosc parametru w czasie t2
     * @return - wartosc logiczną true jesli t1=0,
     * a t2 = 1, i false w pozostalych przypadkach
     */
    public static boolean ACTIV(boolean t1, boolean t2) {
        return !t1 && t2;
    }

    /**
     * Deaktywacja
     * @param t1 - wartosc parametru w czasie t1
     * @param t2 - wartosc parametru w czasie t2
     * @return - wartosc logiczną true jesli t1=1,
     * a t2 = 0, i false w pozostalych przypadkach
     */
    public static boolean DEACTIV(boolean t1, boolean t2) {
        return t1 && !t2;
    }
}
