package math.linear;

import math.shapes.Arrow;
import math.utils.MathUtil;
import math.utils.Tuple2d;

import java.awt.*;

public class LinearUtil {
    private LinearUtil(){}
    public static Vector2 polarToCart(Polar polar) {
        double xx = polar.getRadius() * Math.cos(polar.getAngle());
        double yy = polar.getRadius() * Math.sin(polar.getAngle());
        return new Vector2(xx, yy);
    }

    public static Polar cartToPolar(Vector2 point) {
        double radius = Math.sqrt(Math.pow(point.getY(), 2)
                + Math.pow(point.getX(), 2));
        double angle = Math.atan2(point.getY(), point.getX());
        return new Polar(radius, angle);
    }

    public static Vector2 add(Vector2 vector1, Vector2 vector2) {
        double x = vector1.getX() + vector2.getX();
        double y = vector1.getY() + vector2.getY();
        return new Vector2(x, y);
    }

    public static Vector3 add(Vector3 vector1, Vector3 vector2) {
        double x = vector1.getX() + vector2.getX();
        double y = vector1.getY() + vector2.getY();
        double z = vector1.getZ() + vector2.getZ();
        return new Vector3(x, y, z);
    }

    public static Vector2 sub(Vector2 vector1, Vector2 vector2) {
        double x = vector1.getX() - vector2.getX();
        double y = vector1.getY() - vector2.getY();
        return new Vector2(x, y);
    }

    public static Vector3 sub(Vector3 vector1, Vector3 vector2) {
        double x = vector1.getX() - vector2.getX();
        double y = vector1.getY() - vector2.getY();
        double z = vector1.getZ() - vector2.getZ();
        return new Vector3(x, y, z);
    }

    public static Vector2 scale(Vector2 vector, double s) {
        double x = vector.getX() * s;
        double y = vector.getY() * s;
        return new Vector2(x, y);
    }

    public static Vector3 scale(Vector3 vector, double s) {
        double x = vector.getX() * s;
        double y = vector.getY() * s;
        double z = vector.getZ() * s;
        return new Vector3(x, y, z);
    }

    public static Vector2 normalize(Vector2 vector) {
        double x = vector.getX() / vector.getLength();
        double y = vector.getY() / vector.getLength();
        return new Vector2(x, y);
    }

    public static Vector3 normalize(Vector3 vector) {
        double x = vector.getX() / vector.getLength();
        double y = vector.getX() / vector.getLength();
        double z = vector.getZ() / vector.getLength();
        return new Vector3(x, y, z);
    }

    public static Vector3 cross(Vector3 vector1, Vector3 vector2) {
        double x = vector1.getY() * vector2.getZ() - vector1.getZ()
                * vector2.getY();
        double y = vector1.getZ() * vector2.getX() - vector1.getX()
                * vector2.getZ();
        double z = vector1.getX() * vector2.getY() - vector1.getY()
                * vector2.getX();
        return new Vector3(x, y, z);
    }

    public static void drawVectorF(float x1, float y1, float x2, float y2,
                                   Graphics2D g2, Color color) {
        float radius = 0;
        double angle = 0;
        Vector2 vect = new Vector2(x2 - x1, y2 - y1);
        radius = (float) vect.getLength();
        angle = MathUtil.radToDeg(vect.getAngle());
        float x0 = 800f;
        float y0 = 800f;
        Arrow ar = new Arrow(x0 / 2 + x1 * 30f, (y0 - 30f) / 2f - y1 * 30f,
                radius * 30f, 1f, (float) angle, 15f, 10f, true);
        g2.setColor(color);
        g2.fill(ar);
        g2.setColor(Color.BLACK);
    }

    public static void drawVectorF(Tuple2d start, Tuple2d end, Graphics2D g2,
                                   Color color) {
        float x1 = (float) start.getX();
        float y1 = (float) start.getY();
        float x2 = (float) end.getX();
        float y2 = (float) end.getY();
        float radius = 0;
        double angle = 0;
        Vector2 vect = new Vector2(x2 - x1, y2 - y1);
        radius = (float) vect.getLength();
        angle = MathUtil.radToDeg(vect.getAngle());
        float x0 = 800f;
        float y0 = 800f;
        Arrow ar = new Arrow(x0 / 2 + x1 * 30f, (y0 - 30f) / 2f - y1 * 30f,
                radius * 30f, 1f, (float) angle, 15f, 10f, true);
        g2.setColor(color);
        g2.fill(ar);
        g2.setColor(Color.BLACK);
    }

    public static void drawVector(Vector2 vector, Graphics2D g2, Color color) {
        float radius = 0;
        double angle = 0;
        radius = (float) vector.getLength();
        angle = MathUtil.radToDeg(vector.getAngle());
        float x0 = 800f;
        float y0 = 800f;
        Arrow ar = new Arrow(x0 / 2, (y0 - 30f) / 2f, radius * 30f, 1f,
                (float) angle, 15f, 10f, true);
        g2.setColor(color);
        g2.fill(ar);
        g2.setColor(Color.BLACK);
    }

    public static void drawPolar(Polar polar, Graphics2D g2, Color color) {
        float radius = 0;
        double angle = 0;
        radius = (float) polar.getRadius();
        angle = MathUtil.radToDeg(polar.getAngle());
        float x0 = 800f;
        float y0 = 800f;
        Arrow ar = new Arrow(x0 / 2, (y0 - 30f) / 2f, radius * 30f, 1f,
                (float) angle, 15f, 10f, true);
        g2.setColor(color);
        g2.fill(ar);
        g2.setColor(Color.BLACK);
    }
}
