package math.fractals;

import java.awt.*;
import javax.swing.*;

public class Fractal15 extends JFrame{
	private static final long serialVersionUID = 8169105040941367402L;
	private static final int fw = 1000;
	private static final int fh = 1000;
	private static final int w = 400;
	private static final int h = 400;

	public static void main(String[] args) {
		SwingUtilities.invokeLater(() -> {
			double x = w / 80.0;
			double y = h / 80.0;
			double headDir = Math.PI;
			double ww = w - 5 * x;
			String[] vars = {"F", "X", "Y", "+", "-"};
			String start = "X";
			String[] rules = {"F", "-YF+XFX+FY-", "+XF-YFY-FX+", "+", "-"};
			double scale = 1.0 / 2.0;
			int steps = 6;
			double angle = Math.PI / 2.0;
			int dx = 600;
			int dy = 100;
			new Fractal15(new Turtle(x, y, headDir, ww, vars, start, rules,
					scale, steps, angle, dx, dy));
		});
	}

	public Fractal15(JComponent comp){
		setLayout(null);
		setPreferredSize(new Dimension(fw, fh));
		setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
				- (fw / 2),
				(Toolkit.getDefaultToolkit().getScreenSize().height / 2)
						- (fh / 2), fw, fh);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setTitle("Ramka Graficzna");
		JPanel panel = (JPanel) comp;
		panel.setLocation((fw - panel.getWidth()) / 2,
				(fh - panel.getHeight()) / 2);
		add(panel);
		setVisible(true);
	}
}
