package math.fibo;

import math.utils.FrequencyMap;

import java.math.BigInteger;

public class Fibo {
    private BigInteger fibo;
    private long n;

    public Fibo(String wyraz) {
        this.n = -1;
        long nn = -1;
        try {
            nn = Long.parseLong(wyraz);
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        n = Math.abs(nn);
        fibo = FiboUtil.fibonacci(n);
    }

    public Fibo(long n) {
        if (n >= 0) {
            this.n = n;
            fibo = FiboUtil.fibonacci(n);
        } else {
            throw new IllegalArgumentException("Niewłaściwa liczba");
        }
    }

    /**
     * oblicza frekwencję cyfr 0 do 9 w danej liczbie Fibonacciego
     *
     * @return 11 elementowa tablica intów.
     * [0] podaje liczbę zer
     * [1] podaje liczbę jedynek
     * itd.
     * [10] liczba cyfr w liczbie (suma [0] do [9])
     */
    public int[] stats() {
        String str = fibo.toString();
        FrequencyMap<String> fm = new FrequencyMap<>();
        int[] tabl = new int[11];
        for (int i = 0; i < str.length(); i++) {
            fm.add(str.substring(i, i + 1));
        }
        for (int j = 0; j < 10; j++) {
            tabl[j] = fm.getFrequency(Integer.toString(j));
        }
        tabl[10] = fm.razem();
        return tabl;
    }

    /**
     * Sumuje cyfry w tej liczbie
     *
     * @return zwraca sumę cyfr
     */
    public BigInteger sumaCyfr() {
        BigInteger bi = new BigInteger("0");
        String str = fibo.toString();
        int len = str.length();
        for (int i = 0; i < len; i++) {
            bi = bi.add(new BigInteger(str.substring(i, i + 1)));
        }
        return bi;
    }

    @Override
    public String toString() {
        return fibo.toString();
    }

    public BigInteger getFibo() {
        return fibo;
    }

    public void setFibo(BigInteger fibo) {
        this.fibo = fibo;
    }

    public long getN() {
        return n;
    }

    public void setN(long n) {
        this.n = n;
    }
}
