package math.fractals;

import math.utils.*;

public class Fractal27 {
	public static double r(double K, double n0, double t, double nt) {
		double b = (K / nt) - 1.0;
		double c = (K / n0) - 1.0;
		return -Math.log(b / c) / (K * t);
	}

	public static int n(double K, double n0, double k, double t) {
		double b = (K / n0) - 1;
		return (int)(K / (1 + b * Math.pow(Math.E, -K * k * t)));
	}

	public static void main(String[] args) {
		double r = r(1000, 2, 4, 70);
		Util.print(r);
		for(int i = 4; i < 16; i++){
			double n = n(1000, 2, r, i);
			Util.print("" + i + " " + n);
		}
	}
}
