package math.fractals;

import java.awt.*;
import javax.swing.*;
import math.axes.*;

class Fractal26 extends JFrame{
	private static final long serialVersionUID = 431281611636634328L;
	public static final int fw = 1000;
	public static final int fh = 1000;

	public static void main(String[] args) {
		SwingUtilities.invokeLater(() -> new Fractal26(new AxPanel01()));
	}

	Fractal26(JComponent comp){
		setLayout(null);
		setPreferredSize(new Dimension(fw, fh));
		setBounds(
				(Toolkit.getDefaultToolkit().getScreenSize().width / 2)
						- (fw / 2),
				(Toolkit.getDefaultToolkit().getScreenSize().height / 2)
						- (fh / 2),
				fw, fh);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setTitle("Ramka Graficzna");
		setResizable(false);
		JPanel panel = (JPanel) comp;
		panel.setLocation((fw - panel.getWidth()) / 2,
				(fh - panel.getHeight()) / 2);
		add(panel);
		setVisible(true);
	}
}

class AxPanel01 extends JPanel{
	private static final long serialVersionUID = 5218506428064759030L;
	private static final int w = 860;
	private static final int h = 860;
	private static final int offset = 30;

	public AxPanel01(){
		setPreferredSize(new Dimension(w, h));
		setSize(w, h);
		setBackground(Color.WHITE);
	}

	@Override
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D)g;
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		Ax diag1 = new Ax(0, 0, 800, 800, 0, 0, 100, 100, g2, 20, 20, offset);
		diag1.drawGrid(Color.GRAY);
		diag1.drawXLegend(true);
		diag1.drawYLegend(true);
		diag1.drawTitle("Równanie Malthusa");
		g2.drawString("Czas (jedn)", 790, 855);
		g2.drawString("N (szt.)", 5, 12);
		float dt = 1f;
		float maxt = diag1.getRw();
		int[] Ns = {10, 10, 10, 10, 10, 10, 10};
		float[] rs = {-0.02f, 0.0f, 0.02f, 0.03f, 0.04f, 0.05f, 0.1f};
		for(int a = 0; a < Ns.length; a++){
			float N = Ns[a];
			float r = rs[a];
			float dN = 0.0f;
			float t = 0;
			for(t = 0; t < maxt; t += dt){
				dN = N * r * dt;
				N += dN;
				if(N > 100){
					N = 100;
				}
				if(N < 99){
					diag1.drawPoint(t, N, 2, PShape.Circle, Color.BLUE);
				}
			}
		}
	}
}
