package math.fractals;

import java.awt.*;
import javax.swing.*;

public class Fractal21 extends JFrame{
	private static final long serialVersionUID = 8169105040941367402L;
	private static final int fw = 1000;
	private static final int fh = 1000;

	public static void main(String[] args) {
		SwingUtilities.invokeLater(() -> new Fractal21(new GridPanel()));
	}

	public Fractal21(JComponent comp){
		setLayout(null);
		setPreferredSize(new Dimension(fw, fh));
		setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
				- (fw / 2),
				(Toolkit.getDefaultToolkit().getScreenSize().height / 2)
						- (fh / 2), fw, fh);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setTitle("Ramka Graficzna");
		JPanel panel = (JPanel) comp;
		panel.setLocation((fw - panel.getWidth()) / 2,
				(fh - panel.getHeight()) / 2);
		add(panel);
		setVisible(true);
	}
}
