package math.fractals;

import javax.swing.*;
import java.awt.*;

public class Fractal03 extends JFrame {
    private static final long serialVersionUID = 431281611636634328L;
    public static final int fw = 1000;
    public static final int fh = 1000;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Fractal03(new FractalPanel03()));
    }

    public Fractal03(JComponent comp) {
        setLayout(null);
        setPreferredSize(new Dimension(fw, fh));
        setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fh / 2), fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        //	setResizable(false);
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}

class FractalPanel03 extends JPanel {
    private static final long serialVersionUID = 5218506428064759030L;
    private static final int w = 800;
    private static final int h = 800;

    public FractalPanel03() {
        setPreferredSize(new Dimension(w, h));
        setSize(w, h);
        setBackground(Color.WHITE);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawRect(0, 0, w - 1, h - 1);
        Point start = new Point(3 * w / 8, 3 * w / 8);
        Point end = new Point(6 * w / 8, 3 * w / 8);
        FractalUtil.drawDragon(g2, Color.BLUE, start, end, 15);
        Point width1 = new Point(6 * w / 8, 3 * h / 8);
        Point height1 = new Point(3 * w / 8, 3 * h / 8);
        FractalUtil.drawDragon(g2, Color.RED, width1, height1, 15);
    }
}