package math.fi;

import java.math.BigDecimal;
import java.math.MathContext;

public class FiUtil {
    private FiUtil(){}
    public static double fi() {
        return (Math.sqrt(5) + 1.0) / 2.0;
    }

    public static BigDecimal bigFi(int precision) {
        MathContext mc = new MathContext(precision);
        BigDecimal a = BigDecimal.valueOf(5).sqrt(mc);
        return a.add(BigDecimal.ONE).divide(new BigDecimal(2),mc);
    }
}
