package math.bezier;

import math.utils.Tuple2d;

import javax.swing.*;
import java.awt.*;

public class Bezier34 extends JFrame {
    private static final long serialVersionUID = 431281611636634328L;
    public static final int fw = 1000;
    public static final int fh = 1000;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Bezier34(new BernsteinPanel34()));
    }

    public Bezier34(JComponent comp) {
        setLayout(null);
        setPreferredSize(new Dimension(fw, fh));
        setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fh / 2), fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        //	setResizable(false);
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}

class BernsteinPanel34 extends JPanel {
    private static final long serialVersionUID = -5183600697149041028L;
    private static final int w = 800;
    private static final int h = 800;

    public BernsteinPanel34() {
        setPreferredSize(new Dimension(w, h));
        setBackground(Color.WHITE);
        setSize(w, h);
        setLayout(null);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.BLACK);
        g2.drawRect(0, 0, w - 1, h - 1);
        g2.setColor(Color.BLUE);
        Tuple2d[] points = {new Tuple2d(60, 160), new Tuple2d(120, 60),
                new Tuple2d(180, 160)};
        double[] weights = {1, 0.3, 1};
        BezierUtil.drawRatBezier2(g2, points, weights, true);
    }
}