package math.trans;

import java.awt.*;
import math.shapes.Triangle;

public class TransUtil{
	private TransUtil(){}

	public static void drawTriangle(float x1, float y1, float x2, float y2,
			float x3, float y3, Graphics2D g2, Color color) {
		float x0 = 800f;
		float y0 = 800f;
		Triangle triangle = new Triangle(x0 / 2 + x1 * 30, (y0 - 30f) / 2f - y1
				* 30, x0 / 2 + x2 * 30, (y0 - 30f) / 2f - y2 * 30, x0 / 2 + x3
				* 30, (y0 - 30f) / 2f - y3 * 30);
		BasicStroke stroke = new BasicStroke(1f, BasicStroke.CAP_SQUARE,
				BasicStroke.JOIN_MITER);
		g2.setColor(color);
		g2.setStroke(stroke);
		g2.draw(triangle);
		g2.setColor(Color.BLACK);
		g2.drawString("A", x0 / 2 + x1 * 30, (y0 - 30f) / 2f - y1 * 30 + 5);
		g2.drawString("B", x0 / 2 + x2 * 30, (y0 - 30f) / 2f - y2 * 30 + 5);
		g2.drawString("C", x0 / 2 + x3 * 30, (y0 - 30f) / 2f - y3 * 30 - 5);
	}

	public static void drawRect(float x1, float y1, float x2, float y2,
			float x3, float y3, float x4, float y4, Graphics2D g2, Color color) {
		float x0 = 800f;
		float y0 = 800f;
		BasicStroke stroke = new BasicStroke(1f, BasicStroke.CAP_SQUARE,
				BasicStroke.JOIN_MITER);
		g2.setColor(color);
		g2.setStroke(stroke);
		g2.drawLine((int)(x0 / 2 + x1 * 30), (int)((y0 - 30f) / 2f - y1 * 30),
				(int)(x0 / 2 + x2 * 30), (int)((y0 - 30f) / 2f - y2 * 30));
		g2.drawLine((int)(x0 / 2 + x2 * 30), (int)((y0 - 30f) / 2f - y2 * 30),
				(int)(x0 / 2 + x3 * 30), (int)((y0 - 30f) / 2f - y3 * 30 - 5));
		g2.drawLine((int)(x0 / 2 + x3 * 30),
				(int)((y0 - 30f) / 2f - y3 * 30 - 5), (int)(x0 / 2 + x4 * 30),
				(int)((y0 - 30f) / 2f - y4 * 30 - 5));
		g2.drawLine((int)(x0 / 2 + x4 * 30),
				(int)((y0 - 30f) / 2f - y4 * 30 - 5), (int)(x0 / 2 + x1 * 30),
				(int)((y0 - 30f) / 2f - y1 * 30));
		g2.setColor(Color.BLACK);
		g2.drawString("A", x0 / 2 + x1 * 30, (y0 - 30f) / 2f - y1 * 30 + 5);
		g2.drawString("B", x0 / 2 + x2 * 30, (y0 - 30f) / 2f - y2 * 30 + 5);
		g2.drawString("C", x0 / 2 + x3 * 30, (y0 - 30f) / 2f - y3 * 30 - 5);
		g2.drawString("D", x0 / 2 + x4 * 30, (y0 - 30f) / 2f - y4 * 30 - 5);
	}
}
